/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.recycle;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.recycle.dto.RecycleRecordStateChangeDTO;
import com.digiwin.athena.atdm.recycle.po.RecycleDO;
import com.digiwin.athena.datamap.sdk.manager.DataMapManager;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmDataEntryDTO;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.result.DeleteResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class CommonRecycleServiceImpl
implements CommonRecycleService {
    private static final Logger log = LoggerFactory.getLogger(CommonRecycleServiceImpl.class);
    private static final String DATE_TIME = "dateTime";
    private static final String INTERNAL_ACCOUNT = "athenaAIRecycle";
    private static final String INTERNAL_ACCOUNT_PWD = "athena_20201015";
    @Autowired(required=false)
    @Qualifier(value="recycleMongoTemplate")
    private MongoTemplate recycleMongoTemplate;

    private MongoTemplate getRecycleMongoTemplate() {
        if (null != this.recycleMongoTemplate) {
            return this.recycleMongoTemplate;
        }
        throw BusinessException.create((String)"\u521b\u5efarecycleMongoTemplate\u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e~");
    }

    @Override
    public int getRecycleCount(String tenantId) {
        List<Map<String, Object>> activityList = this.queryActivityList(tenantId);
        if (CollectionUtil.isEmpty(activityList)) {
            return 0;
        }
        IntSummaryStatistics summaryStatistics = activityList.stream().collect(Collectors.summarizingInt(t -> (Integer)t.get("count")));
        return Math.toIntExact(summaryStatistics.getSum());
    }

    @Override
    public List<Map<String, Object>> queryActivityList(String tenantId) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria("state").ne((Object)9)), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{DATE_TIME}), Aggregation.group((String[])new String[]{"activityCode"}).sum("dataSize").as("count").first("activityCode").as("activityCode").first(DATE_TIME).as(DATE_TIME)});
        AggregationResults results = this.getRecycleMongoTemplate().aggregate(aggregation, tenantId, RecycleDO.class);
        List<Object> recycleList = (ArrayList)results.getRawResults().get((Object)"results");
        this.dataTimeOrder(recycleList, DATE_TIME);
        recycleList = this.assignActivityName(recycleList);
        return recycleList;
    }

    private List<Map<String, Object>> assignActivityName(List<Map<String, Object>> recycleList) {
        if (CollectionUtil.isEmpty(recycleList)) {
            return recycleList;
        }
        List dataEntries = (List)DataMapManager.getDataEntryList((String)"allow").getResponse();
        List activityCodeList = dataEntries.stream().map(TmDataEntryDTO::getCode).distinct().collect(Collectors.toList());
        recycleList = recycleList.stream().filter(recyle -> activityCodeList.contains(recyle.get("activityCode"))).collect(Collectors.toList());
        Map<String, String> codeNameRel = dataEntries.stream().collect(Collectors.toMap(TmDataEntryDTO::getCode, TmDataEntryDTO::getName, (value1, value2) -> value2));
        recycleList.forEach(recycle -> recycle.put("activityName", codeNameRel.get(recycle.get("activityCode"))));
        return recycleList;
    }

    @Override
    public List queryActivityDataList(String tenantId, String activityCode) {
        Criteria criteria = Criteria.where((String)"activityCode").is((Object)activityCode).and("state").ne((Object)9);
        Query query = Query.query((CriteriaDefinition)criteria);
        List recycleList = this.getRecycleMongoTemplate().find(query, RecycleDO.class, tenantId);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        for (RecycleDO recycleDO : recycleList) {
            for (Map<String, Object> data : recycleDO.getPageData()) {
                if (MapUtils.isEmpty(data)) continue;
                data.remove("uibot_checked");
                dataList.add(data);
            }
        }
        this.dataTimeOrder(dataList, "uibot__dateTime");
        return dataList;
    }

    @Override
    public void insertRecycle(AuthoredUser authoredUser, String activityCode, List<Map<String, Object>> dataList) {
        RecycleDO recycleDO = new RecycleDO();
        recycleDO.setTenantId(authoredUser.getTenantId());
        recycleDO.setActivityCode(activityCode);
        recycleDO.setActivityName(null);
        String sequenceNo = UUID.randomUUID().toString();
        LocalDateTime dateTime = LocalDateTime.now();
        for (Map<String, Object> data : dataList) {
            data.put("uibot__userId", authoredUser.getUserId());
            data.put("uibot__userName", authoredUser.getUserName());
            data.put("uibot__dateTime", dateTime);
            data.put("uibot__sequenceNo", sequenceNo);
        }
        recycleDO.setPageData(dataList);
        recycleDO.setDataSize(dataList.size());
        recycleDO.setDateTime(dateTime);
        recycleDO.setVersion(1);
        recycleDO.setSequenceNo(sequenceNo);
        recycleDO.setState(1);
        this.checkAndCreateCollection(authoredUser.getTenantId());
        this.getRecycleMongoTemplate().insert((Object)recycleDO, authoredUser.getTenantId());
    }

    private void checkAndCreateCollection(String collectionName) {
        if (this.getRecycleMongoTemplate().collectionExists(collectionName)) {
            return;
        }
        ArrayList<IndexModel> indexModelList = new ArrayList<IndexModel>();
        BasicDBObject index = new BasicDBObject();
        index.put((Object)DATE_TIME, (Object)-1);
        indexModelList.add(new IndexModel((Bson)index));
        try {
            this.getRecycleMongoTemplate().createCollection(collectionName).createIndexes(indexModelList);
        }
        catch (Exception ex) {
            log.info("RecycleService-checkAndCreateCollection: create collection: {} failed, error: {}", (Object)collectionName, (Object)ex);
        }
    }

    @Override
    public void deleteRecycle(AuthoredUser authoredUser, String activityCode, List<Map<String, Object>> dataList) {
        HashMap<String, List> seqDataList = new HashMap<String, List>();
        for (Map<String, Object> map : dataList) {
            String sequenceNo = String.valueOf(map.get("uibot__sequenceNo"));
            List dataMapList = seqDataList.computeIfAbsent(sequenceNo, seqNo -> new ArrayList());
            dataMapList.add(map);
        }
        for (Map.Entry entry : seqDataList.entrySet()) {
            this.deleteRecycle(authoredUser, activityCode, (String)entry.getKey(), (List)entry.getValue());
        }
    }

    public void deleteRecycle(AuthoredUser authoredUser, String activityCode, String sequenceNo, List<Map<String, Object>> toDeleteDataList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"sequenceNo").is((Object)sequenceNo));
        List recycleDos = this.getRecycleMongoTemplate().find(query, RecycleDO.class, authoredUser.getTenantId());
        if (CollectionUtils.isEmpty((Collection)recycleDos)) {
            return;
        }
        RecycleDO recycleDO = (RecycleDO)recycleDos.get(0);
        List<Map<String, Object>> pageDataList = recycleDO.getPageData();
        if (CollectionUtils.isEmpty(pageDataList)) {
            this.deleteBySeqNoAndVersion(authoredUser.getTenantId(), recycleDO.getSequenceNo(), recycleDO.getVersion());
            return;
        }
        int origSize = pageDataList.size();
        Iterator<Map<String, Object>> iterator = pageDataList.iterator();
        block0: while (iterator.hasNext()) {
            Map<String, Object> pageData = iterator.next();
            Object dataKey = pageData.containsKey("RECYCLE__DATA_KEY") ? pageData.get("RECYCLE__DATA_KEY") : pageData.get("__DATA_KEY");
            for (Map<String, Object> toDeleteData : toDeleteDataList) {
                Object dataKey1 = toDeleteData.containsKey("RECYCLE__DATA_KEY") ? toDeleteData.get("RECYCLE__DATA_KEY") : toDeleteData.get("__DATA_KEY");
                if (!Objects.equals(dataKey, dataKey1)) continue;
                iterator.remove();
                continue block0;
            }
        }
        if (CollectionUtils.isEmpty(pageDataList)) {
            this.deleteBySeqNoAndVersion(authoredUser.getTenantId(), recycleDO.getSequenceNo(), recycleDO.getVersion());
            return;
        }
        if (origSize == pageDataList.size()) {
            return;
        }
        query = Query.query((CriteriaDefinition)Criteria.where((String)"sequenceNo").is((Object)sequenceNo).and("version").is((Object)recycleDO.getVersion()));
        Update update = Update.update((String)"pageData", pageDataList).set("dataSize", (Object)pageDataList.size()).set("version", (Object)(recycleDO.getVersion() + 1));
        this.getRecycleMongoTemplate().updateFirst(query, (UpdateDefinition)update, authoredUser.getTenantId());
    }

    public long deleteBySeqNoAndVersion(String tenantId, Object sequenceNo, Object version) {
        if (null == sequenceNo || null == version) {
            return 0L;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"sequenceNo").is(sequenceNo).and("version").is(version));
        DeleteResult deleteRet = this.getRecycleMongoTemplate().remove(query, tenantId);
        return deleteRet.getDeletedCount();
    }

    @Override
    public void deleteAll(String tenantId) {
        this.getRecycleMongoTemplate().dropCollection(tenantId);
    }

    @Override
    public void deleteByActivityCode(AuthoredUser authoredUser, String tmActivityId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"activityCode").is((Object)tmActivityId));
        this.getRecycleMongoTemplate().remove(query, authoredUser.getTenantId());
    }

    private void dataTimeOrder(List list, String compareParam) {
        Collections.sort(list, (o1, o2) -> {
            Date time1 = (Date)o1.get(compareParam);
            Date time2 = (Date)o2.get(compareParam);
            return time2.compareTo(time1);
        });
    }

    @Override
    public void markExpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        this.checkPwd(recycleRecordStateChangeDTO.getAccount(), recycleRecordStateChangeDTO.getPassword());
        ArrayList updateList = new ArrayList();
        BulkOperations operations = this.getRecycleMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, recycleRecordStateChangeDTO.getTenantId());
        recycleRecordStateChangeDTO.getActivityCodeList().forEach(activityCode -> {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"activityCode").is(activityCode));
            Update update = new Update();
            update.set("state", (Object)9);
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        operations.updateMulti(updateList);
        operations.execute();
    }

    @Override
    public void markUnexpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        this.checkPwd(recycleRecordStateChangeDTO.getAccount(), recycleRecordStateChangeDTO.getPassword());
        ArrayList updateList = new ArrayList();
        BulkOperations operations = this.getRecycleMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, recycleRecordStateChangeDTO.getTenantId());
        recycleRecordStateChangeDTO.getActivityCodeList().forEach(activityCode -> {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"activityCode").is(activityCode));
            Update update = new Update();
            update.set("state", (Object)1);
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        operations.updateMulti(updateList);
        operations.execute();
    }

    @Override
    public void markDeleted(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        this.checkPwd(recycleRecordStateChangeDTO.getAccount(), recycleRecordStateChangeDTO.getPassword());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"activityCode").in(recycleRecordStateChangeDTO.getActivityCodeList()));
        this.getRecycleMongoTemplate().remove(query, recycleRecordStateChangeDTO.getTenantId());
    }

    private void checkPwd(String account, String password) {
        if (!StringUtils.equals((String)account, (String)INTERNAL_ACCOUNT) || !StringUtils.equals((String)password, (String)INTERNAL_ACCOUNT_PWD)) {
            throw BusinessException.create((String)ErrorCodeEnum.RECYCLE_PWD_ERROR.getErrCode(), (String)"\u8d26\u53f7\u3001\u5bc6\u7801\u9519\u8bef");
        }
    }
}

