/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.retrieveData;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.retrieveData.CommonRetrieveDataService;
import com.digiwin.athena.atdm.retrieveData.RetrieveDataConverter;
import com.digiwin.athena.atdm.retrieveData.dto.RetrieveDataDTO;
import com.digiwin.athena.atdm.retrieveData.po.RetrieveDataDO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CommonRetrieveDataServiceImpl
implements CommonRetrieveDataService {
    private static final String COLLECTION_NAME = "retrieve_data";
    @Autowired(required=false)
    @Qualifier(value="retrieveDataMongoTemplate")
    private MongoTemplate retrieveDataMongoTemplate;
    @Autowired
    private RetrieveDataConverter retrieveDataConverter;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private MessageUtils messageUtils;

    private MongoTemplate getRetrieveDataMongoTemplate() {
        if (null != this.retrieveDataMongoTemplate) {
            return this.retrieveDataMongoTemplate;
        }
        throw BusinessException.create((String)"\u521b\u5efaretrieveDataMongoTemplate\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e~");
    }

    @Override
    public void saveRetrieveData(RetrieveDataDTO retrieveDataDTO) {
        RetrieveDataDO retrieveDataDO = this.retrieveDataConverter.convert(retrieveDataDTO);
        retrieveDataDO.setDateTime(LocalDateTime.now());
        if (null == retrieveDataDTO.getTerminateTime()) {
            retrieveDataDO.setDateTime(LocalDateTime.now());
        } else {
            retrieveDataDO.setDateTime(retrieveDataDTO.getTerminateTime());
        }
        BulkOperations operations = this.getRetrieveDataMongoTemplate().bulkOps(BulkOperations.BulkMode.UNORDERED, COLLECTION_NAME);
        operations.insert((Object)retrieveDataDO);
        operations.execute();
    }

    @Override
    public List queryRetrieveDataList(AuthoredUser authoredUser, String tmActivityId, List<String> workItemIds) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()).and("activityId").in(workItemIds);
        Query query = Query.query((CriteriaDefinition)criteria);
        List retrieveDataList = this.getRetrieveDataMongoTemplate().find(query, RetrieveDataDO.class, COLLECTION_NAME);
        ArrayList resultList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)retrieveDataList)) {
            String operationType = this.messageUtils.getMessage("shelved_uibot__operation_type_withdraw");
            String firstActivityId = ((RetrieveDataDO)retrieveDataList.get(0)).getActivityId();
            String firstBacklogId = ((RetrieveDataDO)retrieveDataList.get(0)).getInitiateActivityId();
            Map<String, String> activityIdNameMap = this.queryActivityNameById(Arrays.asList(firstActivityId), Arrays.asList(firstBacklogId));
            String activityName = null;
            if (MapUtils.isNotEmpty(activityIdNameMap)) {
                activityName = activityIdNameMap.get(firstActivityId);
                activityName = StringUtils.isNotBlank((String)activityName) ? activityName : activityIdNameMap.get(firstBacklogId);
            }
            for (RetrieveDataDO retrieveDataDO : retrieveDataList) {
                resultList.addAll(this.buildRetrievePageData(operationType, activityName, retrieveDataDO));
            }
        }
        return resultList;
    }

    private Map<String, String> queryActivityNameById(List<String> workItemIdList, List<String> backlogIdList) {
        if (CollectionUtils.isEmpty(workItemIdList) && CollectionUtils.isEmpty(backlogIdList)) {
            return Collections.emptyMap();
        }
        return this.atmcService.queryActivityNameById(workItemIdList, backlogIdList);
    }

    private List buildRetrievePageData(String operationType, String activityName, RetrieveDataDO retrieveDataDO) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String withdrawDateTimeStr = TimeUtils.format((LocalDateTime)retrieveDataDO.getDateTime(), (String)"yyyy/MM/dd HH:mm:ss");
        for (Map<String, Object> rowData : retrieveDataDO.getPageData()) {
            rowData.put("uibot__userId", retrieveDataDO.getUserId());
            rowData.put("uibot__userName", retrieveDataDO.getUserName());
            rowData.put("uibot__operationReason", "");
            rowData.put("uibot__operationType", operationType);
            rowData.put("uibot__dateTime", retrieveDataDO.getDateTime());
            rowData.put("uibot__initiateActivityId", retrieveDataDO.getActivityId());
            rowData.put("uibot__initiateActivityCode", retrieveDataDO.getInitiateActivityId());
            rowData.put("uibot__initiateActivityName", activityName);
            rowData.put("uibot__link", false);
            rowData.remove("uibot_checked");
            if (null != rowData.get("__DATA_KEY")) {
                String dataKey = rowData.get("__DATA_KEY").toString();
                String initiateActivityCodeStr = null != rowData.get("uibot__initiateActivityCode") ? rowData.get("uibot__initiateActivityCode").toString() : "NAN";
                String newDataKey = operationType + ";" + retrieveDataDO.getUserId() + ";" + withdrawDateTimeStr + ";" + initiateActivityCodeStr + ";" + dataKey;
                rowData.put("__DATA_KEY", newDataKey);
            }
            resultList.add(rowData);
        }
        return resultList;
    }
}

