/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.semc;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.semc.CommonTddService;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigDTO;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigVO;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonTddServiceImpl
implements CommonTddService {
    private static final Logger log = LoggerFactory.getLogger(CommonTddServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public EncryptedConfigVO getEncryptedConfig(EncryptedConfigDTO encryptedConfigDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AuthoredUser proxyAuthoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
        String url = this.envProperties.getTddUri() + "/encrypted/getEncryptedConfig";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-middleware-auth-user", proxyAuthoredUser != null ? proxyAuthoredUser.getToken() : authoredUser.getToken());
            HttpEntity requestEntity = new HttpEntity((Object)encryptedConfigDTO, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<EncryptedConfigVO>>(){}, new Object[0]);
            return (EncryptedConfigVO)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String makePassword(Integer passwordStreflgth, Integer passwordLength) {
        String url = this.envProperties.getTddUri() + "/encrypted/makePassword";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("defenceComplexity", passwordStreflgth);
        params.put("defenceLength", passwordLength);
        HttpHeaders headerMap = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headerMap);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        Map responseWithException = (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        if (responseWithException.containsKey("defence")) {
            return responseWithException.get("defence") + "";
        }
        return null;
    }
}

