/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.taskengine;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDataDto;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.taskengine.CommonTaskEngineService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonTaskEngineServiceImpl
implements CommonTaskEngineService {
    private static final Logger log = LoggerFactory.getLogger(CommonTaskEngineServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void execute(Action action) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        ActionServiceId actionServiceId = serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;
        if (StringUtils.hasText((String)serviceId.getProxyToken())) {
            headerMap.add("digi-middleware-auth-user", serviceId.getProxyToken());
            headerMap.add("token", serviceId.getProxyToken());
        }
        String serviceUri = this.envProperties.getTaskEngineUri() + serviceId.getServiceUri();
        String tenantId = serviceId.getTenant_id();
        LogDto logDto = new LogDto("\u6267\u884c\u4efb\u52a1\u5f15\u64ceaction\u5f00\u59cb\uff0cserviceUri\uff1a" + serviceUri, tenantId + ";" + serviceUri);
        LogDataDto logDataDto = new LogDataDto(serviceId.getServiceUri(), "\u8c03\u7528url", "link", "taskEngine");
        logDto.setData(Arrays.asList(logDataDto));
        log.info(logDto.toString());
        try {
            HttpEntity httpEntity = new HttpEntity(action.getParas(), (MultiValueMap)headerMap);
            ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            LogDto logDtoSuccess = new LogDto("\u6267\u884c\u4efb\u52a1\u5f15\u64ceaction\u6210\u529f\uff0cserviceUri\uff1a" + serviceUri, tenantId + ";" + serviceUri);
            LogDataDto logDataDtoSuccess = new LogDataDto(serviceId.getServiceUri(), "\u8c03\u7528url", "link", "taskEngine");
            logDtoSuccess.setData(Arrays.asList(logDataDtoSuccess));
            log.info(logDtoSuccess.toString());
        }
        catch (Exception ex) {
            LogDto logDtoFail = new LogDto("\u6267\u884c\u4efb\u52a1\u5f15\u64ceaction\u5931\u8d25\uff0cserviceUri\uff1a" + serviceUri, serviceId.getTenant_id() + ";" + serviceUri);
            LogDataDto logDataDtoFail = new LogDataDto(serviceId.getServiceUri(), "\u8c03\u7528url", "link", "taskEngine");
            logDtoFail.setData(Arrays.asList(logDataDtoFail));
            log.error(logDtoFail.toString());
            log.error("[\u6267\u884c\u4efb\u52a1\u5f15\u64ce] serviceUri: {}, body: {}, error: ", new Object[]{serviceUri, JsonUtils.objectToString(action.getParas()), ex});
            throw ex;
        }
    }

    @Override
    public Map<String, Object> startNewProject(String userId, String projectCode, Map<String, Object> eocMap, Map<String, Object> variables, List<Map<String, Object>> dispatchDataList) {
        String url = this.envProperties.getTaskEngineUri() + "api/project/create";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("projectCode", projectCode);
        body.put("requesterId", userId);
        body.put("dispatchData", dispatchDataList);
        body.put("variables", variables);
        body.put("process_EOC", eocMap);
        log.error("[\u4efb\u52a1\u5f15\u64ce\u53d1\u8d77\u65b0\u9879\u76ee] body: {}", (Object)JsonUtils.objectToString(body));
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("[\u4efb\u52a1\u5f15\u64ce\u53d1\u8d77\u65b0\u9879\u76ee] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }
}

