/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.activity.domain.TmActivityDefinition;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.thememap.CommonThemeMapQueryService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonThemeMapQueryServiceImpl
implements CommonThemeMapQueryService {
    private static final Logger log = LoggerFactory.getLogger(CommonThemeMapQueryServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public TmActivity getActivityAction(ExecuteContext pageContext) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/activityDefinition?taskId=" + pageContext.getTmProjectId() + "&activityId=" + pageContext.getTmActivityId() + "&pageCode=" + pageContext.getPageCode();
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", pageContext.getLocale());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, TmActivityDefinition.class, new Object[0]);
            TmActivity tmActivity = (TmActivity)((TmActivityDefinition)((Object)responseEntity.getBody())).getResponseWithException(this.messageUtils.getMessage("exception.KG.find.activity.define2"));
            this.setTmActivityValue(tmActivity);
            return tmActivity;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    private void setTmActivityValue(TmActivity tmActivity) {
        if (MapUtils.isEmpty(tmActivity.getDataSources())) {
            return;
        }
        tmActivity.getDataSources().forEach((k, v) -> {
            if (StringUtils.isBlank((String)v.getName())) {
                v.setName((String)k);
            }
        });
    }

    @Override
    public ActionInfo getActionInfo(String tenantId, String actionId) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("actionId", actionId);
        HttpHeaders headers = new HttpHeaders();
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/Action/queryExecutionInfo";
        HttpEntity httpEntity = new HttpEntity(parameter, (MultiValueMap)headers);
        try {
            ResponseEntity actionResult = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ActionInfo>>(){}, new Object[0]);
            return (ActionInfo)((BaseResultDTO)actionResult.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(parameter), (Object)ex);
            return null;
        }
    }

    @Override
    public Object queryVariable(String value, SubmitExecuteContext context) {
        return this.queryVariable(context.getAuthoredUser().getTenantId(), context.getLocale(), value);
    }

    @Override
    public Object queryVariable(String tenantId, String locale, String value) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/mechanism/variable?variableName=" + value + "&tenantId=" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, BaseResultDTO.class, new Object[0]);
            if (!ObjectUtils.isEmpty((Object)responseEntity.getBody())) {
                BaseResultDTO body = (BaseResultDTO)responseEntity.getBody();
                return ((Map)body.getResponse()).get(value);
            }
            return null;
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            return null;
        }
    }
}

