/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import com.digiwin.athena.atdm.thememap.dto.BaseItemDto;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanDTO;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanItemsDTO;
import com.digiwin.athena.atdm.thememap.dto.TmAppDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonThemeMapServiceImpl
implements CommonThemeMapService {
    private static final Logger log = LoggerFactory.getLogger(CommonThemeMapServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public HashMap<String, Object> executeFormula(String formulaId) {
        String uri = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/tenantSettings/formula?formulaId={formulaId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formulaId", formulaId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return (HashMap)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)uri, (Object)ex);
            throw ex;
        }
    }

    @Override
    public HashMap<String, Object> post(String uri, Map parameter) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HttpEntity httpEntity = new HttpEntity((Object)parameter, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            Object response = ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            if (response instanceof Map) {
                return (HashMap)response;
            }
            if (response instanceof List) {
                List respList = (List)response;
                if (CollectionUtils.isNotEmpty((Collection)respList)) {
                    return (HashMap)respList.get(0);
                }
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)parameter), (Object)ex);
            throw ex;
        }
    }

    @Override
    public HashMap<String, Object> postByRelativeUri(String relativeUri, Map parameter) {
        String uri = this.envProperties.getWebThemeMapUri() + relativeUri;
        return this.post(uri, parameter);
    }

    @Override
    public List<SuggestPlanItemsDTO> getSuggestPlan(String locale, String decisionCode, List<Map<String, Object>> data) {
        String url = this.envProperties.getDataMapUri() + "/restful/standard/datamap/mechanismEngine/sourceData";
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("type", "decision");
        body.put("code", decisionCode);
        body.put("datas", data);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<SuggestPlanDTO>>(){}, new Object[0]);
            if (((BaseResultDTO)responseEntity.getBody()).getResponseWithException("") == null) {
                log.warn(url + "\u8fd4\u56denull");
                return null;
            }
            return ((SuggestPlanDTO)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("")).getSuggest();
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<BaseItemDto> getActivitiesByPattern(String pattern) {
        String url = this.envProperties.getKnowledgeGraphUri() + "/knowledgegraph/task/activitiesAndSortByPattern?pattern={pattern}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pattern", pattern);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<BaseItemDto>>>(){}, param);
        return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {
        String url = this.envProperties.getKnowledgeGraphUri() + "knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>(){}, new Object[0]);
        }
        catch (Exception e) {
            log.error("execute km [knowledgegraph/task/applicationRelation] fail, error = {}", (Object)e.getMessage());
        }
        if (null != respEntity && null != respEntity.getBody()) {
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        return null;
    }
}

