package com.digiwin.athena.atdm.aam;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 附件数据库实体类
 *
 * @author majfa
 * @date 2020.11.14
 * @since [迭代10，附件]
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class AttachmentEntity   {
    /**
     * 文档中心生成的附件id
     */
    private String id;

    /**
     * 附件名称
     */
    private String name;

    /**
     * table行数据唯一标示key
     */
    private String rowDataKey;

    /**
     * 附件目录名称id
     */
    private String categoryId;

    /**
     * 附件目录名
     */
    private String category;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 活动id
     */
    private String taskId;

    /**
     * 附件大小
     */
    private Integer size;

    /**
     * 上传者用户id
     */
    private String uploadUserId;

    /**
     * 上传者用户名称
     */
    private String uploadUserName;

    /**
     * 附件描述
     */
    private String description;
    protected LocalDateTime createDate;

    protected LocalDateTime modifyDate;

    /**
     * 加密密码
     */
    private String defence;
}
