package com.digiwin.athena.atdm.aam;

import com.digiwin.athena.atdm.action.dto.DmcAccount;

import java.util.List;
import java.util.Map;

public interface CommonAttachmentService {
    /**
     * 根据任务id、项目id、目录列表、rowDataKey列表等查询附件列表
     *
     * @param tenantId       租户id
     * @param taskId         tmActivityId
     * @param projectId      tmProjectId
     * @param categories     附件目录列表
     * @param rowDataKeyList 行数据标识列表
     * @return 附件信息
     */
    List<AttachmentEntity> queryRowDataAttachmentList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList);

    /**
     * 上传保存or删除附件
     *
     * @param uploadedAttachmentList 上传的附件列表
     * @param deletedAttachmentList  删除的附件列表
     * @param needDeleteDmcFile      是否需要调用dmc删除附件信息
     */
    void uploadOrDeleteAttachment(List uploadedAttachmentList, List deletedAttachmentList, Boolean needDeleteDmcFile);

    /**
     * 删除附件
     *
     * @param deletedAttachmentList  删除的附件列表
     */
    void deleteAttachment(List deletedAttachmentList, Map<String, DmcAccount> schemaDmcAccountMap);
}
