package com.digiwin.athena.atdm.activity.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class GroupSettingOptionDTO {
    private String componentName;

    private Boolean defaultOption;

    private GroupFieldDTO groupFields;

    private NotifyGroup notifyGroup;

    private List<Order> orderList;

    /**
     * 当为排序选项时（type=order)时，表示排序类别，如：date-desc
     */
    private String orderType;

    private String platform;

    private String schema;

    private List<SummaryType> summaryTypes;

    /**
     * 选项类别：分组（group）、排序（order）
     */
    private String type;

    private String title;

    private String value;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Order {
        private String orderType;

        private String schema;

        private String value;

        private String title;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SummaryType {
        private String description;

        private String schema;

        private String type;

        private String value;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class NotifyGroup {
        private String schema;

        private String subtitle;

        private String title;

        private String value;
    }
}
