package com.digiwin.athena.atdm.audc;

import com.digiwin.athena.aim.sdk.manager.AudcManager;
import com.digiwin.athena.aim.sdk.meta.dto.request.AccessibleReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.AccessibleRespDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.action.dto.TenantConfigDTO;
import com.digiwin.athena.atdm.uibot.dto.UserDefinedCenterMetadataResult;
import com.digiwin.athena.atdm.audc.dto.UserTrackExtendDTO;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * AudcServiceImpl Description
 *
 * @author majianfu
 * @date 2022/2/15
 * @since
 */
@Slf4j
@Service
public class CommonAudcServiceImpl implements CommonAudcService {
    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public TenantConfigDTO getTenantConfig(String tenantId, String category) {
        String url = envProperties.getAudcUri() + "/api/audc/v1/tenant/config";
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity<>(null, headers);

        String finalUrl = UriComponentsBuilder.fromHttpUrl(url)
                .queryParam("tenantId", tenantId)
                .queryParam("category", category)
                .toUriString();
        try {
            ResponseEntity<BaseResultDTO<TenantConfigDTO>> respEntity = restTemplate.exchange(finalUrl, HttpMethod.GET, httpEntity
                    , new ParameterizedTypeReference<BaseResultDTO<TenantConfigDTO>>() {
                    });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("url: {}, error: ", finalUrl, ex);
            throw ex;
        }
    }

    @Override
    public List<UserDefinedCenterMetadataResult> getFieldsSeqByUser(Map<String, Object> paramMap, ExecuteContext executeContext) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            String url = envProperties.getAudcUri() + "/api/audc/v1/userdefined/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}";
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.add("locale", executeContext.getLocale());
                headers.add("digi-middleware-auth-user", authoredUser.getToken());
                headers.add("proxy_token", authoredUser.getToken());
                headers.add("security-token", null);

                HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
                ResponseEntity<BaseResultDTO<List<UserDefinedCenterMetadataResult>>> responseEntity = null;
                responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity, new ParameterizedTypeReference<BaseResultDTO<List<UserDefinedCenterMetadataResult>>>() {
                }, paramMap);
                return responseEntity.getBody().getResponseWithException("");
            } catch (Exception e) {
                log.error(e.getMessage(),e);
                return  null;
            }
        }

    /**
     * 埋点
     * @param authoredUser
     * @param list
     */
    @Override
    public void reportUserTrack(AuthoredUser authoredUser, List<UserTrackExtendDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String uri = envProperties.getAudcUri() + "/api/v1/user/track/report";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(JsonUtils.objectToString(list), headers);
            ResponseEntity<BaseResultDTO<Object>> respEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Object>>() {
            });
            // 请求失败，直接抛出异常
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                Objects.requireNonNull(respEntity.getBody()).getResponse();
            } else {
                log.error("exception.audc.report.userTrack.fail", httpEntity);
            }
        } catch (Exception e) {
            log.error("exception.audc.report.userTrack.fail", e.getMessage());
        }
    }

    @Override
    public List<AccessibleRespDTO> checkTypeActivitiesAccessible(List<String> activityId) {
        if (CollectionUtils.isEmpty(activityId)) {
            return Collections.emptyList();
        }
        List<AccessibleReqDTO> typeActivitiesList = new ArrayList<>();
        AccessibleReqDTO accessibleReqDTO = new AccessibleReqDTO();
        accessibleReqDTO.setType("0");
        accessibleReqDTO.setTmActivityIdList(activityId);
        typeActivitiesList.add(accessibleReqDTO);

        return AudcManager.checkAccessible(typeActivitiesList).data();
    }
}
