package com.digiwin.athena.atdm.cac;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.action.dto.BaseCacResult;
import com.digiwin.athena.atdm.action.dto.UserAppDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Slf4j
@Service
public class CommonCacServiceImpl implements CommonCacService {

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;


    @Override
    public List<UserAppDTO> qryUserApp() {

        String uri = envProperties.getCacUrl() + "authorizations/current/user/apps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseCacResult<List<UserAppDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                new ParameterizedTypeReference<BaseCacResult<List<UserAppDTO>>>() {
                });
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(responseEntity.getBody().getCode())){
                return responseEntity.getBody().getData();
            }
        }
        catch (Exception e) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", e.getMessage());
        }
        return null;
    }


}
