package com.digiwin.athena.atdm.dto;
import lombok.Data;

import java.util.Map;

/**
 * 业务参数
 */
@Data
public class ActionInfoDTO {

    /**
     * 数据源id
     */
    String actionId;

    /**
     * 作业名称
     */
    String name;

    /**
     * 作业编码
     */
    String code;

    /**
     * 单双档类型
     * 双档：DOUBLE-DOCUMENT
     * 单档：SIGN-DOCUMENT
     */
    String category;

    /**
     * 导出文件名
     */
    String fileName;

    /**
     * 导出字段，支持双档，若是双档，第一个元素为单头，第二个为单身
     */
    Map<String, Object> selectField;

    /**
     * 对于导入的API，表明导入的数据使用哪个M字段来传递；
     * 对于导入模板下载的API，表示生成模板的M字段；
     * 对于导出的API，表示导出哪个M字段的数据；
     */
    String targetField;

    /**
     * 调用esp接口参数
     */
    Map<String, Object> actionParas;

    /**
     * 导出zip包加密密码
     */
    private String defence;

    /**
     * 配置的模版批注
     */
    Map<String, Object> annotation;

}
