package com.digiwin.athena.atdm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName ImportStatisticsDTO
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/12 11:30
 * @Version 1.0
 **/
@Data
public class ImportStatisticsDTO {

    private Long id;
    private String masterId;
    private String activityId;
    private String activityName;
    private String userId;
    private String userJson;
    private String userToken;
    private String locale;
    private String actionId;
    private Integer succeededNum;
    private Integer processingNum;
    private Integer failedNum;
    // 错误个数
    private Integer errorNum;
    private String failedUrl;
    private Integer republished;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    private String routerKey;
    /**
     * 业务参数数据
     */
    private String actionInfo;

    /**
     * 导入类型
     */
    private String type;

    /**
     *  导入模式 insert , update, insertOrUpdate
     */
    private String importModel;

    /**
     * 耗时
     */
    private String consumeTime;

    /**
     * 访问权限
     */
    private String access;

    /**
     * 本次查询总数
     */
    private Integer queryPageTotal;

}
