package com.digiwin.athena.atdm.thememap;



import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;

/**
 * 从tm获取配置
 */
public interface CommonThemeMapQueryService {

    /**
     * 获取TM 活动的定义
     * @param pageContext
     * @return
     */
    TmActivity getActivityAction(ExecuteContext pageContext);


    /**
     * 追加action相关的信息
     * @param tenantId
     * @param actionId
     */
    ActionInfo getActionInfo(String tenantId, String actionId);

    /**
     * 查询km
     * @param value
     * @param context
     * @return
     */
    Object queryVariable(String value, SubmitExecuteContext context);

    /**
     * 从KM查询交付设计器设置的变量
     *
     * @param tenantId
     * @param locale
     * @param value
     * @return
     */
    Object queryVariable(String tenantId, String locale, String value);

}
