package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.action.dto.ActionInfo;
import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.activity.domain.TmActivityDefinition;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class CommonThemeMapQueryServiceImpl implements CommonThemeMapQueryService {

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 获取TM 活动的定义
     * @param pageContext
     * @return
     */
    public TmActivity getActivityAction(ExecuteContext pageContext){
        String url=envProperties.getKnowledgeGraphUri()+"knowledgegraph/task/activityDefinition?taskId="+pageContext.getTmProjectId()+"&activityId="+pageContext.getTmActivityId()+"&pageCode="+pageContext.getPageCode();
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale",pageContext.getLocale());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<TmActivityDefinition> responseEntity =restTemplate.exchange(url, HttpMethod.GET, requestEntity, TmActivityDefinition.class);
            TmActivity tmActivity = responseEntity.getBody().getResponseWithException(messageUtils.getMessage("exception.KG.find.activity.define2"));
            setTmActivityValue(tmActivity);
            return tmActivity;
        }catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;

//            String message = MessageFormat.format(messageUtils.getMessage("exception.KG.find.activity.define"), url);
//            throw BusinessException.create(599, "599", message, message, "", e);
        }
    }


    /**
     * 设置 数据源name 值
     * @param tmActivity
     */
    private void setTmActivityValue(TmActivity tmActivity){
        if(MapUtils.isEmpty(tmActivity.getDataSources())){
            return;
        }
        tmActivity.getDataSources().forEach((k,v)->{
            if(StringUtils.isBlank(v.getName())){
                v.setName(k);
            }
        });
    }

    @Override
    public ActionInfo getActionInfo(String tenantId,String actionId) {
        Map<String, Object> parameter = new HashMap<>();
        parameter.put("actionId", actionId);
        HttpHeaders headers = new HttpHeaders();
        String url=envProperties.getKnowledgeGraphUri()+"knowledgegraph/Action/queryExecutionInfo";
        HttpEntity httpEntity = new HttpEntity<Map>(parameter,headers);
        try {
            ResponseEntity<BaseResultDTO<ActionInfo>> actionResult = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<ActionInfo>>() {
            });
            return actionResult.getBody().getResponseWithException("");

        }catch (Exception ex){
            //吃掉异常
            log.error("body: {}, error: ", JsonUtils.objectToString(parameter), ex);
            return null;
        }
    }

    @Override
    public Object queryVariable(String value, SubmitExecuteContext context) {
        return queryVariable(context.getAuthoredUser().getTenantId(), context.getLocale(), value);
    }

    @Override
    public Object queryVariable(String tenantId, String locale, String value) {
        String url = envProperties.getKnowledgeGraphUri() + "knowledgegraph/mechanism/variable?variableName=" + value + "&tenantId=" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        //headers.add("token",context.getAuthoredUser().getToken());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity, BaseResultDTO.class);
            if (!ObjectUtils.isEmpty(responseEntity.getBody())) {
                BaseResultDTO<Map> body = responseEntity.getBody();
                return body.getResponse().get(value);
            }
            return null;
        } catch (Exception e) {
            //吃掉异常
            log.error("url: {}, error: ", url, e);
            return null;
        }
    }
}
