package com.digiwin.athena.atdm.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;


/**
 * @description: 自动生成
 * @author: wangminga
 * @create: 2020-10-12 10:33
 **/

@Configuration
public class DataCommonMongoTemplateConfig {
    @Value("${spring.data.mongodb.uri:}")
    private String uriLog;

    @Value("${spring.data.mongodb.database:}")
    private String databaseLog;

    @Value("${spring.data.mongodb-recycle.uri:}")
    private String recycleUri;

    @Value("${spring.data.mongodb-recycle.database:}")
    private String recycleDatabase;

    @Value("${spring.data.mongodb-terminateData.uri:}")
    private String terminateDataUri;

    @Value("${spring.data.mongodb-terminateData.database:}")
    private String terminateDatabase;

    @Value("${spring.data.mongodb-retrieveData.uri:}")
    private String retrieveDataUri;

    @Value("${spring.data.mongodb-retrieveData.database:}")
    private String retrieveDatabase;

    @Value("${spring.data.mongodb-dataUniformity.uri:}")
    private String dataUniformityUri;

    @Value("${spring.data.mongodb-dataUniformity.database:}")
    private String dataUniformityDatabase;

    @Value("${spring.data.mongodb-espRequestWorkItem.database:}")
    private String espRequestWorkItemDatabase;

    @ConditionalOnProperty(name = "spring.data.mongodb.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "mongoTemplate")
    @Bean("mongoTemplate")
    public MongoTemplate mongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(uriLog)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate(client, databaseLog);
        setTypeMapper(mongoTemplate);
        return mongoTemplate;
    }

    private void setTypeMapper(MongoTemplate mongoTemplate) {
        MongoConverter converter = mongoTemplate.getConverter();
        // 去掉_class属性
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter) converter).setTypeMapper(new DefaultMongoTypeMapper(null));
        }
    }

    @ConditionalOnProperty(name = "spring.data.mongodb-recycle.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "recycleMongoTemplate")
    @Bean("recycleMongoTemplate")
    public MongoTemplate recycleMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(recycleUri)).build(), null);
        MongoTemplate recycleMongoTemplate = new MongoTemplate(client, recycleDatabase);
        setTypeMapper(recycleMongoTemplate);
        return recycleMongoTemplate;
    }

    @ConditionalOnProperty(name = "spring.data.mongodb-terminateData.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "terminateDataMongoTemplate")
    @Bean("terminateDataMongoTemplate")
    public MongoTemplate terminateDataMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(terminateDataUri)).build(), null);
        MongoTemplate terminateDataMongoTemplate = new MongoTemplate(client, terminateDatabase);
        setTypeMapper(terminateDataMongoTemplate);
        return terminateDataMongoTemplate;
    }

    @ConditionalOnProperty(name = "spring.data.mongodb-retrieveData.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "retrieveDataMongoTemplate")
    @Bean("retrieveDataMongoTemplate")
    public MongoTemplate retrieveDataMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(retrieveDataUri)).build(), null);
        MongoTemplate retrieveDataMongoTemplate = new MongoTemplate(client, retrieveDatabase);
        setTypeMapper(retrieveDataMongoTemplate);
        return retrieveDataMongoTemplate;
    }

    @ConditionalOnProperty(name = "spring.data.mongodb-dataUniformity.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "dataUniformityMongoTemplate")
    @Bean("dataUniformityMongoTemplate")
    public MongoTemplate dataUniformityMongoTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(dataUniformityUri)).build(), null);
        MongoTemplate dataUniformityMongoTemplate = new MongoTemplate(client, dataUniformityDatabase);
        setTypeMapper(dataUniformityMongoTemplate);
        return dataUniformityMongoTemplate;
    }

    @ConditionalOnProperty(name = "spring.data.mongodb-espRequestWorkItem.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "espRequestWorkItemTemplate")
    @Bean("espRequestWorkItemTemplate")
    public MongoTemplate espRequestWorkItemTemplate() {
        MongoClient client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(dataUniformityUri)).build(), null);
        MongoTemplate espRequestWorkItemTemplate = new MongoTemplate(client, espRequestWorkItemDatabase);
        setTypeMapper(espRequestWorkItemTemplate);
        return espRequestWorkItemTemplate;
    }
}
