package com.digiwin.athena.atdm.dataUniformity;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author：SYQ
 * @date：2022/5/10
 */
@Service
public class DataUniformityMongodbServiceImpl implements DataUniformityMongodbService {
    @Autowired(required = false)
    @Qualifier("dataUniformityMongoTemplate")
    private MongoTemplate dataUniformityMongoTemplate;

    private MongoTemplate getDataUniformityMongoTemplate() {
        if (null != dataUniformityMongoTemplate) {
            return dataUniformityMongoTemplate;
        }
        throw BusinessException.create("创建dataUniformityMongoTemplate失败，请检查数据源配置是否正确~");
    }

    @Override
    public List<Map> selectTransactionData(String collection,List<String> cardId) {
        Query query = Query.query(Criteria.where("type").is("workitem")
                .and("cardId").in(cardId).and("optType").ne(null).ne("")
                .and("dealType").ne("end"));
        query.fields().include("bk").include("cardId").exclude("_id");
        return getDataUniformityMongoTemplate().find(query,Map.class,collection);
    }

    @Override
    public void updateDealType(String collection, List<Map<String,Object>> updataDataList) {
        for (Map<String,Object> dataMap : updataDataList){
            TreeMap treeMap = JsonUtils.jsonToObject(JsonUtils.objectToString(dataMap.get("bk")), TreeMap.class);
            Long workitemId = Long.valueOf(dataMap.get("workitemId").toString());
            Query query = Query.query(Criteria.where("bk").is(treeMap).and("cardId").is(workitemId));
            Update update = new Update();
            update.set("dealType", dataMap.get("dealType"));
            update.set("modifyDate", LocalDateTime.now());
            getDataUniformityMongoTemplate().updateFirst(query,update,collection);
        }
    }

    @Override
    public List<Map> getBkByCardId(String collection, List<Long> cardIds) {
        Query query = Query.query(Criteria.where("type").is("workitem").and("cardId").in(cardIds));
        return getDataUniformityMongoTemplate().find(query,Map.class,collection);
    }

    @Override
    public void updateCompleted(String collection,List<Map<String,Object>> updataDataList) {
        for(Map<String,Object> dataMap : updataDataList){
            TreeMap treeMap = JsonUtils.jsonToObject(JsonUtils.objectToString(dataMap.get("bk")), TreeMap.class);
            Long workitemId = Long.valueOf(dataMap.get("workitemId").toString());
            Query query = Query.query(Criteria.where("bk").is(treeMap).and("cardId").is(workitemId));
            Update update = new Update();
            update.set("completed", true);
            update.set("modifyDate", LocalDateTime.now());
            getDataUniformityMongoTemplate().updateFirst(query,update,collection);
        }
    }

    @Override
    public void recordSubmittedData(String collection , Long backlogId, Map<String,Object> submitData) {
        //创建集合和索引
        DataUniformitySubmitDO dataUniformitySubmitDO = new DataUniformitySubmitDO();
        dataUniformitySubmitDO.setCardId(backlogId);
        dataUniformitySubmitDO.setData(submitData);
        dataUniformitySubmitDO.setSubmitTime(LocalDateTime.now());
        getDataUniformityMongoTemplate().insert(dataUniformitySubmitDO, collection);
    }


}
