package com.digiwin.athena.atdm.datasource.domain;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @description: 页面相关上下文
 **/
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ExecuteContext {
    /**
     * 语言别
     */
    private String locale;

    /**
     * 客户端来源
     */
    private String clientAgent;

    /**
     * 客户端类型 standardweb:标准前端web
     */
    private String agentType;

    /**
     * 启用精简报文，默认不开启
     */
    private Boolean enableSimplifyPack = Boolean.FALSE;

    /**
     * 执行者performer或者当责者charge
     */
    private String identity;

    /**
     * 项目名称
     */
    private String tmProjectId;

    /**
     * 关卡名称
     */
    private String tmActivityId;

    /**
     * 代办项id，一般再提交的时候用
     */
    private Long backlogId;

    /**
     * ptmBacklogId
     */
    private String ptmBacklogId;

    /**
     * 代理的token
     */
    private String proxyToken;
    /**
     * 登陆用户
     */
    @JsonIgnore
    private AuthoredUser authoredUser;

    /**
     * 页面场景
     * [project-card,project-detail,task-card,task-detail]
     */
    private String pageCode;


    /**
     * 短地址应用的设备类型，目前仅有email
     */
    private String deviceType;


    /**
     * 短地址应用的设备值，当deviceType为email时，表示收件人的email地址
     */
    private String deviceValue;

    /**
     * 活动形态分类
     */
    private String pattern;

    /**
     * 活动形态类型
     */
    private String category;

    /**
     * 数据的状态
     *    waiting 待处理
     *    tracing 追踪中
     *    completed 已完成
     *    processing 处理中
     */
    private String dataStateCode;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 营运单元
     */
    private Map<String, Object> businessUnit;
//    /**
//     * 任务相关的数据
//     */
//    private ProjectData projectData;
//    /**
//     * 任务相关的数据
//     */
//    private TaskWithBacklogData taskWithBacklogData;
//    /**
//     * 由前端确定，是否是开窗，如果是开窗，不走模板
//     */
//    private Boolean openWindow;

//    /**
//     * 任务、项目是否为被分享的
//     */
//    private Boolean isShared;


    /**
     * 活动定义的全局参数
     * 目前用到的币别
     * currency {小数点位数 ：decimal_places ,取数方式：decimal_places_type}
     */
    private Map<String, Object> activityParameter;


    private JSONObject settings;

    /**
     * ESP数据源对应表名
     */
    private String gridSchema;

    /**
     * 是否是历史项目/任务
     */
    private Boolean isHistory;

    /**
     * 应用 code
     */
    private String application;

    public ExecuteContext(String locale, String clientAgent, String identity, String tmProjectId, String tmActivityId, Long backlogId, String proxyToken, AuthoredUser authoredUser, String pageCode, String deviceType, String deviceValue, String pattern, String category, String dataStateCode, String tenantId, Map<String, Object> businessUnit, Map<String, Object> activityParameter, JSONObject settings) {
        this.locale = locale;
        this.clientAgent = clientAgent;
        this.identity = identity;
        this.tmProjectId = tmProjectId;
        this.tmActivityId = tmActivityId;
        this.backlogId = backlogId;
        this.proxyToken = proxyToken;
        this.authoredUser = authoredUser;
        this.pageCode = pageCode;
        this.deviceType = deviceType;
        this.deviceValue = deviceValue;
        this.pattern = pattern;
        this.category = category;
        this.dataStateCode = dataStateCode;
        this.tenantId = tenantId;
        this.businessUnit = businessUnit;
        this.activityParameter = activityParameter;
        this.settings = settings;
    }

    //    /**
//     * 任务or项目不是被分享的
//     *
//     * @return
//     */
//    @JsonIgnore
//    public boolean isNotShared() {
//        return null == isShared || false == isShared;
//    }
//
//    /**
//     * 任务or项目是被分享的
//     *
//     * @return
//     */
//    @JsonGetter("isShared")
//    public boolean isShared() {
//        return BooleanUtils.isTrue(isShared);
//    }

    public ExecuteContext appendHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        this.setClientAgent(clientAgent);
        this.setLocale(locale);
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        this.setAuthoredUser(authoredUser);
        this.setTenantId(authoredUser.getTenantId());
        return this;
    }

    public ExecuteContext appendExtend(JSONObject settings) {
        this.settings = settings;
        return this;
    }

    public ExecuteContext appendExecuteContext(ExecuteContext executeContext) {
        this.setClientAgent(executeContext.getClientAgent());
        this.setLocale(executeContext.getLocale());
        this.setAuthoredUser(executeContext.getAuthoredUser());
        return this;
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.PROXY_AUTH_USER);
        if(authoredUser==null) {
            authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        }
        ExecuteContext executeContext = ExecuteContext.builder()
                .clientAgent(clientAgent)
                .locale(locale)
                .authoredUser(authoredUser)
                .tenantId(authoredUser.getTenantId())
                .build();
        return executeContext;
    }


    public static ExecuteContext createByHttpRequest(HttpServletRequest request, String pageCode, String tmProjectId, String tmActivityId) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty(clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser) request.getAttribute(GlobalConstant.AUTH_USER);
        ExecuteContext executeContext = ExecuteContext.builder()
                .clientAgent(clientAgent)
                .locale(locale)
                .authoredUser(authoredUser)
                .tenantId(authoredUser.getTenantId())
                .pageCode(pageCode)
                .tmActivityId(tmActivityId)
                .tmProjectId(tmProjectId)
//                .isShared(isShared)
                .build();
        return executeContext;
    }

//    /**
//     * 活动信息 存入执行上下文
//     */
//    public void tmActivityToExecuteContext(TmActivity tmActivity) {
//        if(StringUtils.isEmpty(this.getTmActivityId())) {
//            this.setTmActivityId(tmActivity.getActivityId());
//        }
//        this.setCategory(tmActivity.getCategory());
//        this.setPattern(tmActivity.getPattern());
//        this.setActivityParameter(tmActivity.getActivityParameter());
//    }

    /**
     * 将 SubmitExecuteContext 转换为 ExecuteContext
     * @param submitExecuteContext
     * @return
     */
    public static ExecuteContext fromSubmitExecuteContent(SubmitExecuteContext submitExecuteContext){
        ExecuteContext executeContext = ExecuteContext.builder()
                .locale(submitExecuteContext.getLocale())
                .clientAgent(submitExecuteContext.getClientAgent())
                .identity(null)
                .tmProjectId(submitExecuteContext.getTmProjectId())
                .tmActivityId(submitExecuteContext.getTmActivityId())
                .proxyToken(submitExecuteContext.getProxyToken())
                .authoredUser(submitExecuteContext.getAuthoredUser())
                .pageCode(submitExecuteContext.getPageCode())
                .deviceType(submitExecuteContext.getDeviceType())
                .deviceValue(null)
                .pattern(submitExecuteContext.getPattern())
                .category(submitExecuteContext.getCategory())
                .tenantId(submitExecuteContext.getTenantId())
                .businessUnit(submitExecuteContext.getBusinessUnit())
//                .taskWithBacklogData(null)
                .activityParameter(null)
                .backlogId(submitExecuteContext.getBacklogId())
                .build();

        return executeContext;
    }

}
