package com.digiwin.athena.atdm.datasource.domain;

import com.digiwin.athena.atdm.datasource.dto.BpmActivityStepDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @description: 自动生成
 * @author: wangminga
 * @create: 2020-09-03 10:52
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TaskWithBacklogData implements Serializable {
    /**
     * 任务数据
     */
    /**
     * bpm 参数数据
     */
    private Map<String,Object> bpmData;

    private JSONObject stateData;

    private Map<String, Object> businessUnit;

    private String tmActivityId;

    private String tmActivityName;

    private  String tmCategory;

    private String tmPattern;
    /**
     * bpm 活动ID
     */
    private String bpmActivityId;

    /**
     * 代理token
     */
    private String proxyToken;
    /**
     * 流程实例编号
     */
    private String processSerialNumber;


    /**
     * BMP - 活动类型
     */
    private String bpmActivityType;

    /**
     * 执行责 ID
     */
    private List<String> performerIds;

    /**
     * 任务的审核详细步骤
     */
    private List<BpmActivityStepDTO> steps;

    /**
     * 签核状态
     */
    private String approvalState;

    /**
     * backlog 数据
     */
    private List<BacklogData> backlog;

    /**
     * 支持撤回的主键表列
     */
    private JSONArray abortDataKeys;

    /**
     * taskUid，任务引擎才会有
     */
    private String taskUid;

    /**
     * 关联的签核信息
     */
    private Map<String, Object> relationApproval;

    public TaskWithBacklogData copy(){
        TaskWithBacklogData taskWithBacklogData = TaskWithBacklogData.builder()
                .bpmData(this.bpmData)
                .stateData(this.stateData)
                .backlog(this.backlog)
                .approvalState(this.approvalState)
                .bpmActivityId(this.bpmActivityId)
                .bpmActivityType(this.bpmActivityType)
                .businessUnit(this.businessUnit)
                .performerIds(this.performerIds)
                .processSerialNumber(this.getProcessSerialNumber())
                .steps(this.steps)
                .tmActivityId(this.tmActivityId)
                .tmActivityName(this.tmActivityName)
                .tmCategory(this.tmCategory)
                .tmPattern(this.tmPattern)
                .taskUid(this.taskUid)
                .build();
        return taskWithBacklogData;
    }
}
