/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm;

import com.digiwin.athena.appcore.AppCoreProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RemoteProperties {
    private static final Logger log = LoggerFactory.getLogger(RemoteProperties.class);
    @Value(value="${server.port}")
    private String port;
    @Autowired
    private AppCoreProperties appCoreProperties;
    @Value(value="${web.uri:}")
    private String webUri;
    @Value(value="${uibot.uri:}")
    private String uibotUri;
    @Value(value="${idrive-business-report.uri:}")
    private String idriveBusinessReportUri;
    @Value(value="${smartdata.uri:}")
    private String webSmartDataUri;
    @Value(value="${smartdata.dataFootPrintUri:}")
    private String dataFootPrintUri;
    @Value(value="${smartdata.dataComparisonUri:}")
    private String dataComparisonUri;
    @Value(value="${smartdata.executionEngineUri:}")
    private String executionEngineUri;
    @Value(value="${smartdata.supportPerson:}")
    private String webSmartDataSupportPerson;
    @Value(value="${lcdp.uri:}")
    private String webLcdpUri;
    @Value(value="${atmc.uri:}")
    private String webAtmcUri;
    @Value(value="${adsc.uri:}")
    private String webAdscUri;
    @Value(value="${iam.uri:}")
    private String iamUri;
    @Value(value="${themeMap.uri:}")
    private String webThemeMapUri;
    @Value(value="${themeMap.dataMapUri:}")
    private String dataMapUri;
    @Value(value="${themeMap.knowledgeGraphUri:}")
    private String knowledgeGraphUri;
    @Value(value="${themeMap.domainUri:}")
    private String webThemeMapDomainUri;
    @Value(value="${themeMap.supportPerson:}")
    private String webThemeMapSupportPerson;
    @Value(value="${bpm.uri:}")
    private String bpmUri;
    @Value(value="${bpm.supportPerson:}")
    private String bpmSupportPerson;
    @Value(value="${taskEngine.uri:}")
    private String taskEngineUri;
    @Value(value="${taskEngine.workflowUri:}")
    private String workflowUri;
    @Value(value="${taskEngine.supportPerson:}")
    private String taskSupportPerson;
    @Value(value="${taskEngine.ptmUri:}")
    private String ptmUri;
    @Value(value="${esp.uri:}")
    private String espUri;
    @Value(value="${esp.supportPerson:}")
    private String espSupportPerson;
    @Value(value="${esp.supportPersonApp:}")
    private String espSupportPersonApp;
    @Value(value="${mdc.uri:}")
    private String mdcUri;
    @Value(value="${mdc.lbUri:}")
    private String mdcLbUri;
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Value(value="${aam.uri}")
    private String aamUri;
    @Value(value="${audc.uri}")
    private String audcUri;
    @Value(value="${fi.uri:}")
    private String fiUri;
    @Value(value="${cloudeia.uri:}")
    private String cloudeiaUri;
    @Value(value="${athena.mock.mockUser:}")
    private String athenaMockUser;
    @Value(value="${athena.mock.mockTenantId:}")
    private String athenaMockTenantId;
    @Value(value="${athena.mock.mockEnv:}")
    private String athenaMockEnv;
    @Value(value="${dap.lmcUri:}")
    private String dapLmcUri;
    @Value(value="${cac.uri:}")
    private String cacUrl;
    @Value(value="${abt.uri:}")
    private String abtUri;
    @Value(value="${tdd.uri:}")
    private String tddUri;
    private String host;
    private String ipAddress;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private String osName;
    private long pid;
    private LocalDateTime startTime;
    private long runtime;
    private int threadCount;

    public void refresh() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(RemoteProperties.byteToM(freeMemory));
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(RemoteProperties.byteToM(totalMemory));
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(RemoteProperties.byteToM(maxMemory));
        this.setOsName(System.getProperty("os.name"));
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (this.ipAddress == null) {
                this.ipAddress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException:{}", (Object)e.getMessage());
            this.setHost("\u672a\u77e5");
        }
        this.setIpAddress(this.ipAddress);
        long startTime = runtimeMXBean.getStartTime();
        LocalDateTime startDate = LocalDateTime.ofEpochSecond(startTime / 1000L, 0, ZoneOffset.ofHours(0));
        this.setStartTime(startDate);
        this.setRuntime(runtimeMXBean.getUptime());
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(RemoteProperties.tryGetPid());
    }

    static long byteToM(long bytes) {
        long kb = bytes / 1024L / 1024L;
        return kb;
    }

    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getPort() {
        return this.port;
    }

    public AppCoreProperties getAppCoreProperties() {
        return this.appCoreProperties;
    }

    public String getWebUri() {
        return this.webUri;
    }

    public String getUibotUri() {
        return this.uibotUri;
    }

    public String getIdriveBusinessReportUri() {
        return this.idriveBusinessReportUri;
    }

    public String getWebSmartDataUri() {
        return this.webSmartDataUri;
    }

    public String getDataFootPrintUri() {
        return this.dataFootPrintUri;
    }

    public String getDataComparisonUri() {
        return this.dataComparisonUri;
    }

    public String getExecutionEngineUri() {
        return this.executionEngineUri;
    }

    public String getWebSmartDataSupportPerson() {
        return this.webSmartDataSupportPerson;
    }

    public String getWebLcdpUri() {
        return this.webLcdpUri;
    }

    public String getWebAtmcUri() {
        return this.webAtmcUri;
    }

    public String getWebAdscUri() {
        return this.webAdscUri;
    }

    public String getIamUri() {
        return this.iamUri;
    }

    public String getWebThemeMapUri() {
        return this.webThemeMapUri;
    }

    public String getDataMapUri() {
        return this.dataMapUri;
    }

    public String getKnowledgeGraphUri() {
        return this.knowledgeGraphUri;
    }

    public String getWebThemeMapDomainUri() {
        return this.webThemeMapDomainUri;
    }

    public String getWebThemeMapSupportPerson() {
        return this.webThemeMapSupportPerson;
    }

    public String getBpmUri() {
        return this.bpmUri;
    }

    public String getBpmSupportPerson() {
        return this.bpmSupportPerson;
    }

    public String getTaskEngineUri() {
        return this.taskEngineUri;
    }

    public String getWorkflowUri() {
        return this.workflowUri;
    }

    public String getTaskSupportPerson() {
        return this.taskSupportPerson;
    }

    public String getPtmUri() {
        return this.ptmUri;
    }

    public String getEspUri() {
        return this.espUri;
    }

    public String getEspSupportPerson() {
        return this.espSupportPerson;
    }

    public String getEspSupportPersonApp() {
        return this.espSupportPersonApp;
    }

    public String getMdcUri() {
        return this.mdcUri;
    }

    public String getMdcLbUri() {
        return this.mdcLbUri;
    }

    public String getEocUri() {
        return this.eocUri;
    }

    public String getAamUri() {
        return this.aamUri;
    }

    public String getAudcUri() {
        return this.audcUri;
    }

    public String getFiUri() {
        return this.fiUri;
    }

    public String getCloudeiaUri() {
        return this.cloudeiaUri;
    }

    public String getAthenaMockUser() {
        return this.athenaMockUser;
    }

    public String getAthenaMockTenantId() {
        return this.athenaMockTenantId;
    }

    public String getAthenaMockEnv() {
        return this.athenaMockEnv;
    }

    public String getDapLmcUri() {
        return this.dapLmcUri;
    }

    public String getCacUrl() {
        return this.cacUrl;
    }

    public String getAbtUri() {
        return this.abtUri;
    }

    public String getTddUri() {
        return this.tddUri;
    }

    public String getHost() {
        return this.host;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public String getOsName() {
        return this.osName;
    }

    public long getPid() {
        return this.pid;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setAppCoreProperties(AppCoreProperties appCoreProperties) {
        this.appCoreProperties = appCoreProperties;
    }

    public void setWebUri(String webUri) {
        this.webUri = webUri;
    }

    public void setUibotUri(String uibotUri) {
        this.uibotUri = uibotUri;
    }

    public void setIdriveBusinessReportUri(String idriveBusinessReportUri) {
        this.idriveBusinessReportUri = idriveBusinessReportUri;
    }

    public void setWebSmartDataUri(String webSmartDataUri) {
        this.webSmartDataUri = webSmartDataUri;
    }

    public void setDataFootPrintUri(String dataFootPrintUri) {
        this.dataFootPrintUri = dataFootPrintUri;
    }

    public void setDataComparisonUri(String dataComparisonUri) {
        this.dataComparisonUri = dataComparisonUri;
    }

    public void setExecutionEngineUri(String executionEngineUri) {
        this.executionEngineUri = executionEngineUri;
    }

    public void setWebSmartDataSupportPerson(String webSmartDataSupportPerson) {
        this.webSmartDataSupportPerson = webSmartDataSupportPerson;
    }

    public void setWebLcdpUri(String webLcdpUri) {
        this.webLcdpUri = webLcdpUri;
    }

    public void setWebAtmcUri(String webAtmcUri) {
        this.webAtmcUri = webAtmcUri;
    }

    public void setWebAdscUri(String webAdscUri) {
        this.webAdscUri = webAdscUri;
    }

    public void setIamUri(String iamUri) {
        this.iamUri = iamUri;
    }

    public void setWebThemeMapUri(String webThemeMapUri) {
        this.webThemeMapUri = webThemeMapUri;
    }

    public void setDataMapUri(String dataMapUri) {
        this.dataMapUri = dataMapUri;
    }

    public void setKnowledgeGraphUri(String knowledgeGraphUri) {
        this.knowledgeGraphUri = knowledgeGraphUri;
    }

    public void setWebThemeMapDomainUri(String webThemeMapDomainUri) {
        this.webThemeMapDomainUri = webThemeMapDomainUri;
    }

    public void setWebThemeMapSupportPerson(String webThemeMapSupportPerson) {
        this.webThemeMapSupportPerson = webThemeMapSupportPerson;
    }

    public void setBpmUri(String bpmUri) {
        this.bpmUri = bpmUri;
    }

    public void setBpmSupportPerson(String bpmSupportPerson) {
        this.bpmSupportPerson = bpmSupportPerson;
    }

    public void setTaskEngineUri(String taskEngineUri) {
        this.taskEngineUri = taskEngineUri;
    }

    public void setWorkflowUri(String workflowUri) {
        this.workflowUri = workflowUri;
    }

    public void setTaskSupportPerson(String taskSupportPerson) {
        this.taskSupportPerson = taskSupportPerson;
    }

    public void setPtmUri(String ptmUri) {
        this.ptmUri = ptmUri;
    }

    public void setEspUri(String espUri) {
        this.espUri = espUri;
    }

    public void setEspSupportPerson(String espSupportPerson) {
        this.espSupportPerson = espSupportPerson;
    }

    public void setEspSupportPersonApp(String espSupportPersonApp) {
        this.espSupportPersonApp = espSupportPersonApp;
    }

    public void setMdcUri(String mdcUri) {
        this.mdcUri = mdcUri;
    }

    public void setMdcLbUri(String mdcLbUri) {
        this.mdcLbUri = mdcLbUri;
    }

    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    public void setAamUri(String aamUri) {
        this.aamUri = aamUri;
    }

    public void setAudcUri(String audcUri) {
        this.audcUri = audcUri;
    }

    public void setFiUri(String fiUri) {
        this.fiUri = fiUri;
    }

    public void setCloudeiaUri(String cloudeiaUri) {
        this.cloudeiaUri = cloudeiaUri;
    }

    public void setAthenaMockUser(String athenaMockUser) {
        this.athenaMockUser = athenaMockUser;
    }

    public void setAthenaMockTenantId(String athenaMockTenantId) {
        this.athenaMockTenantId = athenaMockTenantId;
    }

    public void setAthenaMockEnv(String athenaMockEnv) {
        this.athenaMockEnv = athenaMockEnv;
    }

    public void setDapLmcUri(String dapLmcUri) {
        this.dapLmcUri = dapLmcUri;
    }

    public void setCacUrl(String cacUrl) {
        this.cacUrl = cacUrl;
    }

    public void setAbtUri(String abtUri) {
        this.abtUri = abtUri;
    }

    public void setTddUri(String tddUri) {
        this.tddUri = tddUri;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteProperties)) {
            return false;
        }
        RemoteProperties other = (RemoteProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        AppCoreProperties this$appCoreProperties = this.getAppCoreProperties();
        AppCoreProperties other$appCoreProperties = other.getAppCoreProperties();
        if (this$appCoreProperties == null ? other$appCoreProperties != null : !this$appCoreProperties.equals(other$appCoreProperties)) {
            return false;
        }
        String this$webUri = this.getWebUri();
        String other$webUri = other.getWebUri();
        if (this$webUri == null ? other$webUri != null : !this$webUri.equals(other$webUri)) {
            return false;
        }
        String this$uibotUri = this.getUibotUri();
        String other$uibotUri = other.getUibotUri();
        if (this$uibotUri == null ? other$uibotUri != null : !this$uibotUri.equals(other$uibotUri)) {
            return false;
        }
        String this$idriveBusinessReportUri = this.getIdriveBusinessReportUri();
        String other$idriveBusinessReportUri = other.getIdriveBusinessReportUri();
        if (this$idriveBusinessReportUri == null ? other$idriveBusinessReportUri != null : !this$idriveBusinessReportUri.equals(other$idriveBusinessReportUri)) {
            return false;
        }
        String this$webSmartDataUri = this.getWebSmartDataUri();
        String other$webSmartDataUri = other.getWebSmartDataUri();
        if (this$webSmartDataUri == null ? other$webSmartDataUri != null : !this$webSmartDataUri.equals(other$webSmartDataUri)) {
            return false;
        }
        String this$dataFootPrintUri = this.getDataFootPrintUri();
        String other$dataFootPrintUri = other.getDataFootPrintUri();
        if (this$dataFootPrintUri == null ? other$dataFootPrintUri != null : !this$dataFootPrintUri.equals(other$dataFootPrintUri)) {
            return false;
        }
        String this$dataComparisonUri = this.getDataComparisonUri();
        String other$dataComparisonUri = other.getDataComparisonUri();
        if (this$dataComparisonUri == null ? other$dataComparisonUri != null : !this$dataComparisonUri.equals(other$dataComparisonUri)) {
            return false;
        }
        String this$executionEngineUri = this.getExecutionEngineUri();
        String other$executionEngineUri = other.getExecutionEngineUri();
        if (this$executionEngineUri == null ? other$executionEngineUri != null : !this$executionEngineUri.equals(other$executionEngineUri)) {
            return false;
        }
        String this$webSmartDataSupportPerson = this.getWebSmartDataSupportPerson();
        String other$webSmartDataSupportPerson = other.getWebSmartDataSupportPerson();
        if (this$webSmartDataSupportPerson == null ? other$webSmartDataSupportPerson != null : !this$webSmartDataSupportPerson.equals(other$webSmartDataSupportPerson)) {
            return false;
        }
        String this$webLcdpUri = this.getWebLcdpUri();
        String other$webLcdpUri = other.getWebLcdpUri();
        if (this$webLcdpUri == null ? other$webLcdpUri != null : !this$webLcdpUri.equals(other$webLcdpUri)) {
            return false;
        }
        String this$webAtmcUri = this.getWebAtmcUri();
        String other$webAtmcUri = other.getWebAtmcUri();
        if (this$webAtmcUri == null ? other$webAtmcUri != null : !this$webAtmcUri.equals(other$webAtmcUri)) {
            return false;
        }
        String this$webAdscUri = this.getWebAdscUri();
        String other$webAdscUri = other.getWebAdscUri();
        if (this$webAdscUri == null ? other$webAdscUri != null : !this$webAdscUri.equals(other$webAdscUri)) {
            return false;
        }
        String this$iamUri = this.getIamUri();
        String other$iamUri = other.getIamUri();
        if (this$iamUri == null ? other$iamUri != null : !this$iamUri.equals(other$iamUri)) {
            return false;
        }
        String this$webThemeMapUri = this.getWebThemeMapUri();
        String other$webThemeMapUri = other.getWebThemeMapUri();
        if (this$webThemeMapUri == null ? other$webThemeMapUri != null : !this$webThemeMapUri.equals(other$webThemeMapUri)) {
            return false;
        }
        String this$dataMapUri = this.getDataMapUri();
        String other$dataMapUri = other.getDataMapUri();
        if (this$dataMapUri == null ? other$dataMapUri != null : !this$dataMapUri.equals(other$dataMapUri)) {
            return false;
        }
        String this$knowledgeGraphUri = this.getKnowledgeGraphUri();
        String other$knowledgeGraphUri = other.getKnowledgeGraphUri();
        if (this$knowledgeGraphUri == null ? other$knowledgeGraphUri != null : !this$knowledgeGraphUri.equals(other$knowledgeGraphUri)) {
            return false;
        }
        String this$webThemeMapDomainUri = this.getWebThemeMapDomainUri();
        String other$webThemeMapDomainUri = other.getWebThemeMapDomainUri();
        if (this$webThemeMapDomainUri == null ? other$webThemeMapDomainUri != null : !this$webThemeMapDomainUri.equals(other$webThemeMapDomainUri)) {
            return false;
        }
        String this$webThemeMapSupportPerson = this.getWebThemeMapSupportPerson();
        String other$webThemeMapSupportPerson = other.getWebThemeMapSupportPerson();
        if (this$webThemeMapSupportPerson == null ? other$webThemeMapSupportPerson != null : !this$webThemeMapSupportPerson.equals(other$webThemeMapSupportPerson)) {
            return false;
        }
        String this$bpmUri = this.getBpmUri();
        String other$bpmUri = other.getBpmUri();
        if (this$bpmUri == null ? other$bpmUri != null : !this$bpmUri.equals(other$bpmUri)) {
            return false;
        }
        String this$bpmSupportPerson = this.getBpmSupportPerson();
        String other$bpmSupportPerson = other.getBpmSupportPerson();
        if (this$bpmSupportPerson == null ? other$bpmSupportPerson != null : !this$bpmSupportPerson.equals(other$bpmSupportPerson)) {
            return false;
        }
        String this$taskEngineUri = this.getTaskEngineUri();
        String other$taskEngineUri = other.getTaskEngineUri();
        if (this$taskEngineUri == null ? other$taskEngineUri != null : !this$taskEngineUri.equals(other$taskEngineUri)) {
            return false;
        }
        String this$workflowUri = this.getWorkflowUri();
        String other$workflowUri = other.getWorkflowUri();
        if (this$workflowUri == null ? other$workflowUri != null : !this$workflowUri.equals(other$workflowUri)) {
            return false;
        }
        String this$taskSupportPerson = this.getTaskSupportPerson();
        String other$taskSupportPerson = other.getTaskSupportPerson();
        if (this$taskSupportPerson == null ? other$taskSupportPerson != null : !this$taskSupportPerson.equals(other$taskSupportPerson)) {
            return false;
        }
        String this$ptmUri = this.getPtmUri();
        String other$ptmUri = other.getPtmUri();
        if (this$ptmUri == null ? other$ptmUri != null : !this$ptmUri.equals(other$ptmUri)) {
            return false;
        }
        String this$espUri = this.getEspUri();
        String other$espUri = other.getEspUri();
        if (this$espUri == null ? other$espUri != null : !this$espUri.equals(other$espUri)) {
            return false;
        }
        String this$espSupportPerson = this.getEspSupportPerson();
        String other$espSupportPerson = other.getEspSupportPerson();
        if (this$espSupportPerson == null ? other$espSupportPerson != null : !this$espSupportPerson.equals(other$espSupportPerson)) {
            return false;
        }
        String this$espSupportPersonApp = this.getEspSupportPersonApp();
        String other$espSupportPersonApp = other.getEspSupportPersonApp();
        if (this$espSupportPersonApp == null ? other$espSupportPersonApp != null : !this$espSupportPersonApp.equals(other$espSupportPersonApp)) {
            return false;
        }
        String this$mdcUri = this.getMdcUri();
        String other$mdcUri = other.getMdcUri();
        if (this$mdcUri == null ? other$mdcUri != null : !this$mdcUri.equals(other$mdcUri)) {
            return false;
        }
        String this$mdcLbUri = this.getMdcLbUri();
        String other$mdcLbUri = other.getMdcLbUri();
        if (this$mdcLbUri == null ? other$mdcLbUri != null : !this$mdcLbUri.equals(other$mdcLbUri)) {
            return false;
        }
        String this$eocUri = this.getEocUri();
        String other$eocUri = other.getEocUri();
        if (this$eocUri == null ? other$eocUri != null : !this$eocUri.equals(other$eocUri)) {
            return false;
        }
        String this$aamUri = this.getAamUri();
        String other$aamUri = other.getAamUri();
        if (this$aamUri == null ? other$aamUri != null : !this$aamUri.equals(other$aamUri)) {
            return false;
        }
        String this$audcUri = this.getAudcUri();
        String other$audcUri = other.getAudcUri();
        if (this$audcUri == null ? other$audcUri != null : !this$audcUri.equals(other$audcUri)) {
            return false;
        }
        String this$fiUri = this.getFiUri();
        String other$fiUri = other.getFiUri();
        if (this$fiUri == null ? other$fiUri != null : !this$fiUri.equals(other$fiUri)) {
            return false;
        }
        String this$cloudeiaUri = this.getCloudeiaUri();
        String other$cloudeiaUri = other.getCloudeiaUri();
        if (this$cloudeiaUri == null ? other$cloudeiaUri != null : !this$cloudeiaUri.equals(other$cloudeiaUri)) {
            return false;
        }
        String this$athenaMockUser = this.getAthenaMockUser();
        String other$athenaMockUser = other.getAthenaMockUser();
        if (this$athenaMockUser == null ? other$athenaMockUser != null : !this$athenaMockUser.equals(other$athenaMockUser)) {
            return false;
        }
        String this$athenaMockTenantId = this.getAthenaMockTenantId();
        String other$athenaMockTenantId = other.getAthenaMockTenantId();
        if (this$athenaMockTenantId == null ? other$athenaMockTenantId != null : !this$athenaMockTenantId.equals(other$athenaMockTenantId)) {
            return false;
        }
        String this$athenaMockEnv = this.getAthenaMockEnv();
        String other$athenaMockEnv = other.getAthenaMockEnv();
        if (this$athenaMockEnv == null ? other$athenaMockEnv != null : !this$athenaMockEnv.equals(other$athenaMockEnv)) {
            return false;
        }
        String this$dapLmcUri = this.getDapLmcUri();
        String other$dapLmcUri = other.getDapLmcUri();
        if (this$dapLmcUri == null ? other$dapLmcUri != null : !this$dapLmcUri.equals(other$dapLmcUri)) {
            return false;
        }
        String this$cacUrl = this.getCacUrl();
        String other$cacUrl = other.getCacUrl();
        if (this$cacUrl == null ? other$cacUrl != null : !this$cacUrl.equals(other$cacUrl)) {
            return false;
        }
        String this$abtUri = this.getAbtUri();
        String other$abtUri = other.getAbtUri();
        if (this$abtUri == null ? other$abtUri != null : !this$abtUri.equals(other$abtUri)) {
            return false;
        }
        String this$tddUri = this.getTddUri();
        String other$tddUri = other.getTddUri();
        if (this$tddUri == null ? other$tddUri != null : !this$tddUri.equals(other$tddUri)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        if (this.getFreeMemory() != other.getFreeMemory()) {
            return false;
        }
        if (this.getTotalMemory() != other.getTotalMemory()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        if (this.getRuntime() != other.getRuntime()) {
            return false;
        }
        return this.getThreadCount() == other.getThreadCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        AppCoreProperties $appCoreProperties = this.getAppCoreProperties();
        result = result * 59 + ($appCoreProperties == null ? 43 : $appCoreProperties.hashCode());
        String $webUri = this.getWebUri();
        result = result * 59 + ($webUri == null ? 43 : $webUri.hashCode());
        String $uibotUri = this.getUibotUri();
        result = result * 59 + ($uibotUri == null ? 43 : $uibotUri.hashCode());
        String $idriveBusinessReportUri = this.getIdriveBusinessReportUri();
        result = result * 59 + ($idriveBusinessReportUri == null ? 43 : $idriveBusinessReportUri.hashCode());
        String $webSmartDataUri = this.getWebSmartDataUri();
        result = result * 59 + ($webSmartDataUri == null ? 43 : $webSmartDataUri.hashCode());
        String $dataFootPrintUri = this.getDataFootPrintUri();
        result = result * 59 + ($dataFootPrintUri == null ? 43 : $dataFootPrintUri.hashCode());
        String $dataComparisonUri = this.getDataComparisonUri();
        result = result * 59 + ($dataComparisonUri == null ? 43 : $dataComparisonUri.hashCode());
        String $executionEngineUri = this.getExecutionEngineUri();
        result = result * 59 + ($executionEngineUri == null ? 43 : $executionEngineUri.hashCode());
        String $webSmartDataSupportPerson = this.getWebSmartDataSupportPerson();
        result = result * 59 + ($webSmartDataSupportPerson == null ? 43 : $webSmartDataSupportPerson.hashCode());
        String $webLcdpUri = this.getWebLcdpUri();
        result = result * 59 + ($webLcdpUri == null ? 43 : $webLcdpUri.hashCode());
        String $webAtmcUri = this.getWebAtmcUri();
        result = result * 59 + ($webAtmcUri == null ? 43 : $webAtmcUri.hashCode());
        String $webAdscUri = this.getWebAdscUri();
        result = result * 59 + ($webAdscUri == null ? 43 : $webAdscUri.hashCode());
        String $iamUri = this.getIamUri();
        result = result * 59 + ($iamUri == null ? 43 : $iamUri.hashCode());
        String $webThemeMapUri = this.getWebThemeMapUri();
        result = result * 59 + ($webThemeMapUri == null ? 43 : $webThemeMapUri.hashCode());
        String $dataMapUri = this.getDataMapUri();
        result = result * 59 + ($dataMapUri == null ? 43 : $dataMapUri.hashCode());
        String $knowledgeGraphUri = this.getKnowledgeGraphUri();
        result = result * 59 + ($knowledgeGraphUri == null ? 43 : $knowledgeGraphUri.hashCode());
        String $webThemeMapDomainUri = this.getWebThemeMapDomainUri();
        result = result * 59 + ($webThemeMapDomainUri == null ? 43 : $webThemeMapDomainUri.hashCode());
        String $webThemeMapSupportPerson = this.getWebThemeMapSupportPerson();
        result = result * 59 + ($webThemeMapSupportPerson == null ? 43 : $webThemeMapSupportPerson.hashCode());
        String $bpmUri = this.getBpmUri();
        result = result * 59 + ($bpmUri == null ? 43 : $bpmUri.hashCode());
        String $bpmSupportPerson = this.getBpmSupportPerson();
        result = result * 59 + ($bpmSupportPerson == null ? 43 : $bpmSupportPerson.hashCode());
        String $taskEngineUri = this.getTaskEngineUri();
        result = result * 59 + ($taskEngineUri == null ? 43 : $taskEngineUri.hashCode());
        String $workflowUri = this.getWorkflowUri();
        result = result * 59 + ($workflowUri == null ? 43 : $workflowUri.hashCode());
        String $taskSupportPerson = this.getTaskSupportPerson();
        result = result * 59 + ($taskSupportPerson == null ? 43 : $taskSupportPerson.hashCode());
        String $ptmUri = this.getPtmUri();
        result = result * 59 + ($ptmUri == null ? 43 : $ptmUri.hashCode());
        String $espUri = this.getEspUri();
        result = result * 59 + ($espUri == null ? 43 : $espUri.hashCode());
        String $espSupportPerson = this.getEspSupportPerson();
        result = result * 59 + ($espSupportPerson == null ? 43 : $espSupportPerson.hashCode());
        String $espSupportPersonApp = this.getEspSupportPersonApp();
        result = result * 59 + ($espSupportPersonApp == null ? 43 : $espSupportPersonApp.hashCode());
        String $mdcUri = this.getMdcUri();
        result = result * 59 + ($mdcUri == null ? 43 : $mdcUri.hashCode());
        String $mdcLbUri = this.getMdcLbUri();
        result = result * 59 + ($mdcLbUri == null ? 43 : $mdcLbUri.hashCode());
        String $eocUri = this.getEocUri();
        result = result * 59 + ($eocUri == null ? 43 : $eocUri.hashCode());
        String $aamUri = this.getAamUri();
        result = result * 59 + ($aamUri == null ? 43 : $aamUri.hashCode());
        String $audcUri = this.getAudcUri();
        result = result * 59 + ($audcUri == null ? 43 : $audcUri.hashCode());
        String $fiUri = this.getFiUri();
        result = result * 59 + ($fiUri == null ? 43 : $fiUri.hashCode());
        String $cloudeiaUri = this.getCloudeiaUri();
        result = result * 59 + ($cloudeiaUri == null ? 43 : $cloudeiaUri.hashCode());
        String $athenaMockUser = this.getAthenaMockUser();
        result = result * 59 + ($athenaMockUser == null ? 43 : $athenaMockUser.hashCode());
        String $athenaMockTenantId = this.getAthenaMockTenantId();
        result = result * 59 + ($athenaMockTenantId == null ? 43 : $athenaMockTenantId.hashCode());
        String $athenaMockEnv = this.getAthenaMockEnv();
        result = result * 59 + ($athenaMockEnv == null ? 43 : $athenaMockEnv.hashCode());
        String $dapLmcUri = this.getDapLmcUri();
        result = result * 59 + ($dapLmcUri == null ? 43 : $dapLmcUri.hashCode());
        String $cacUrl = this.getCacUrl();
        result = result * 59 + ($cacUrl == null ? 43 : $cacUrl.hashCode());
        String $abtUri = this.getAbtUri();
        result = result * 59 + ($abtUri == null ? 43 : $abtUri.hashCode());
        String $tddUri = this.getTddUri();
        result = result * 59 + ($tddUri == null ? 43 : $tddUri.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        long $freeMemory = this.getFreeMemory();
        result = result * 59 + (int)($freeMemory >>> 32 ^ $freeMemory);
        long $totalMemory = this.getTotalMemory();
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        long $pid = this.getPid();
        result = result * 59 + (int)($pid >>> 32 ^ $pid);
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        long $runtime = this.getRuntime();
        result = result * 59 + (int)($runtime >>> 32 ^ $runtime);
        result = result * 59 + this.getThreadCount();
        return result;
    }

    public String toString() {
        return "RemoteProperties(port=" + this.getPort() + ", appCoreProperties=" + this.getAppCoreProperties() + ", webUri=" + this.getWebUri() + ", uibotUri=" + this.getUibotUri() + ", idriveBusinessReportUri=" + this.getIdriveBusinessReportUri() + ", webSmartDataUri=" + this.getWebSmartDataUri() + ", dataFootPrintUri=" + this.getDataFootPrintUri() + ", dataComparisonUri=" + this.getDataComparisonUri() + ", executionEngineUri=" + this.getExecutionEngineUri() + ", webSmartDataSupportPerson=" + this.getWebSmartDataSupportPerson() + ", webLcdpUri=" + this.getWebLcdpUri() + ", webAtmcUri=" + this.getWebAtmcUri() + ", webAdscUri=" + this.getWebAdscUri() + ", iamUri=" + this.getIamUri() + ", webThemeMapUri=" + this.getWebThemeMapUri() + ", dataMapUri=" + this.getDataMapUri() + ", knowledgeGraphUri=" + this.getKnowledgeGraphUri() + ", webThemeMapDomainUri=" + this.getWebThemeMapDomainUri() + ", webThemeMapSupportPerson=" + this.getWebThemeMapSupportPerson() + ", bpmUri=" + this.getBpmUri() + ", bpmSupportPerson=" + this.getBpmSupportPerson() + ", taskEngineUri=" + this.getTaskEngineUri() + ", workflowUri=" + this.getWorkflowUri() + ", taskSupportPerson=" + this.getTaskSupportPerson() + ", ptmUri=" + this.getPtmUri() + ", espUri=" + this.getEspUri() + ", espSupportPerson=" + this.getEspSupportPerson() + ", espSupportPersonApp=" + this.getEspSupportPersonApp() + ", mdcUri=" + this.getMdcUri() + ", mdcLbUri=" + this.getMdcLbUri() + ", eocUri=" + this.getEocUri() + ", aamUri=" + this.getAamUri() + ", audcUri=" + this.getAudcUri() + ", fiUri=" + this.getFiUri() + ", cloudeiaUri=" + this.getCloudeiaUri() + ", athenaMockUser=" + this.getAthenaMockUser() + ", athenaMockTenantId=" + this.getAthenaMockTenantId() + ", athenaMockEnv=" + this.getAthenaMockEnv() + ", dapLmcUri=" + this.getDapLmcUri() + ", cacUrl=" + this.getCacUrl() + ", abtUri=" + this.getAbtUri() + ", tddUri=" + this.getTddUri() + ", host=" + this.getHost() + ", ipAddress=" + this.getIpAddress() + ", freeMemory=" + this.getFreeMemory() + ", totalMemory=" + this.getTotalMemory() + ", maxMemory=" + this.getMaxMemory() + ", osName=" + this.getOsName() + ", pid=" + this.getPid() + ", startTime=" + this.getStartTime() + ", runtime=" + this.getRuntime() + ", threadCount=" + this.getThreadCount() + ")";
    }
}

