/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.aam;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.aam.AttachmentConverter;
import com.digiwin.athena.atdm.aam.CommonAttachmentService;
import com.digiwin.athena.atdm.aam.dto.AttachmentEntity;
import com.digiwin.athena.atdm.aam.dto.DmcAccount;
import com.digiwin.athena.base.sdk.aam.application.meta.request.QueryAttachmentReqDTO;
import com.digiwin.athena.base.sdk.aam.application.service.QueryAttachmentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonAttachmentServiceImpl
implements CommonAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(CommonAttachmentServiceImpl.class);
    private static final String QUERY_URL = "/api/aam/v1/attachment";
    @Autowired
    private RemoteProperties remoteProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private QueryAttachmentService queryAttachmentService;

    @Override
    public List<AttachmentEntity> queryRowDataAttachmentList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
        QueryAttachmentReqDTO reqDTO = new QueryAttachmentReqDTO();
        reqDTO.setTenantId(tenantId);
        reqDTO.setTaskId(taskId);
        reqDTO.setProjectId(projectId);
        reqDTO.setCategoryList(categories);
        reqDTO.setRowDataKeyList(rowDataKeyList);
        List attachmentRespDTOS = this.queryAttachmentService.queryByTaskIdAndRowDataKeyList(reqDTO);
        if (CollectionUtils.isNotEmpty((Collection)attachmentRespDTOS)) {
            return attachmentRespDTOS.stream().map(AttachmentConverter.INSTANCE::toAttachmentEntity).collect(Collectors.toList());
        }
        return new ArrayList<AttachmentEntity>();
    }

    @Override
    public void uploadOrDeleteAttachment(List uploadedAttachmentList, List deletedAttachmentList, Boolean needDeleteDmcFile) {
        String url = this.remoteProperties.getAamUri() + "/api/aam/v1/uploadOrDeleteAttachment";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("uploadedFileList", uploadedAttachmentList);
        body.put("deletedFileList", deletedAttachmentList);
        body.put("needDeleteDmcFile", needDeleteDmcFile);
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("[uploadOrDeleteAttachment] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }

    @Override
    public void deleteAttachment(List deleteAttachmentList, Map<String, DmcAccount> schemaDmcAccountMap) {
        String url = this.remoteProperties.getAamUri() + "/api/aam/v1/deleteAttachmentBatch";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("deleteFileList", deleteAttachmentList);
        if (MapUtils.isNotEmpty(schemaDmcAccountMap)) {
            body.put("schemaDmcAccountMap", schemaDmcAccountMap);
        }
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("[uploadOrDeleteAttachment] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }
}

