/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.atmc;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.atmc.dto.ActivityData;
import com.digiwin.athena.atdm.atmc.dto.ApiErrorInfoDTO;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class CommonAtmcServiceImpl
implements CommonAtmcService {
    private static final Logger log = LoggerFactory.getLogger(CommonAtmcServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(CommonAtmcServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    private static final String ATMC_LOCAL = "locale";
    private static final ParameterizedTypeReference<BaseResultDTO<ExecuteResult>> executeActionResultType = new ParameterizedTypeReference<BaseResultDTO<ExecuteResult>>(){};

    private String getWebAtmcReqUrl(String path) {
        return UriComponentsBuilder.fromHttpUrl((String)this.envProperties.getWebAtmcUri()).path(path).toUriString();
    }

    @Override
    public void emptyActivityData(Map data) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/empty/activity/data");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        try {
            this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)data), (Object)e);
            throw e;
        }
    }

    @Override
    public void resetActivityData(Map data) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/reset/activity/data");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        try {
            this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)data), (Object)e);
            throw e;
        }
    }

    @Override
    public void setBpmActivityTraceData(String backlogId, String startDataState, String targetDataState, Map data) {
        String url = this.getWebAtmcReqUrl(String.format("api/atmc/v1/backlog/%s/activity/startState/%s/targetState/%s", backlogId, startDataState, targetDataState));
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        try {
            this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)data), (Object)e);
            throw e;
        }
    }

    @Override
    public void setBpmActivityStateData(String backlogId, Map data) {
        String url = this.getWebAtmcReqUrl(String.format("api/atmc/v1/backlog/%s/reset/activity/statedata", backlogId));
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        try {
            this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("url: {}, body: {}, error: ", new Object[]{url, JsonUtils.objectToString((Object)data), e});
            throw e;
        }
    }

    @Override
    public void abortTask(Long originalBacklogId, String processSerialNumber, String workitemId) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/activity/abortTask");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("originalBacklogId", originalBacklogId);
        data.put("processSerialNumber", processSerialNumber);
        data.put("workitemId", workitemId);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<String>>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(data), (Object)ex);
            throw ex;
        }
    }

    @Override
    public void closeBpmActivityByBacklog(Long backlogId) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/activity/closeBpmActivityByBacklog");
        HashMap<String, Long> data = new HashMap<String, Long>();
        data.put("backlogId", backlogId);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<String>>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(data), (Object)ex);
            throw ex;
        }
    }

    @Override
    public void updateBacklogApprovalState(Map<String, Object> data) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/updateApprovalState");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<String>>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(data), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<Map> getChangeTaskDataSource(Map param) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/datasource/changetask");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)param), (Object)e);
            throw e;
        }
    }

    @Override
    public List<Map> getOverdueTaskDataSource(Map param) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/datasource/overdueTask");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)param), (Object)e);
            throw e;
        }
    }

    @Override
    public List<Map> saveOverdueTaskDataSource(Map param) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/datasource/overdueTask/save");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)param), (Object)e);
            throw e;
        }
    }

    @Override
    public List<Map> getOverdueTaskListDataSource(Map param) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/datasource/overdueTask/traceList");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)param), (Object)e);
            throw e;
        }
    }

    @Override
    public void sendEmailToHandleApiExecuteError(String type, Object emailData) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/apiExecuteError/sendEmail");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(emailData, (MultiValueMap)headers);
        String finalUrl = url + "?type=" + type;
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(finalUrl, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, body: {}, error: ", new Object[]{finalUrl, JsonUtils.objectToString((Object)emailData), ex});
            throw ex;
        }
    }

    @Override
    public List<Map> getConfig(List<String> configName) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/config/query");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        String finalUrl = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("name", (Object[])configName.toArray(new String[0])).toUriString();
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(finalUrl, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)finalUrl, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void closeApiExecuteErrorWorkItem(String processSerialNumber) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/apiExecuteError/closeBacklog");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("keyId", processSerialNumber);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<String>>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(data), (Object)ex);
            throw ex;
        }
    }

    @Override
    public BaseResultDTO manualTaskStateChanged(List<Map<String, Object>> dataList) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/activity/changed/manualTask");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity(dataList, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
            return (BaseResultDTO)respEntity.getBody();
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(dataList), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<Map> queryCardListByBk(String type, Long backlogId, List<Map> bkList, boolean forceNeedEntityName) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/dataUniformity/queryCardListByBk");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("type", type);
        body.put("cardId", backlogId);
        body.put("forceNeedEntityName", forceNeedEntityName);
        body.put("bkList", bkList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("\u4eceATMC\u83b7\u53d6BK\u4fe1\u606f\u62a5\u9519\uff1abody: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<Object> executeDataSourceDataQuery(ExecuteContext executeContext, Action action, Map<String, Object> parameter) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/datasource/execute/query/data");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("executeContext", executeContext);
        body.put("action", action);
        body.put("parameter", parameter);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Object>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }

    @Override
    public Map getPtmData(Long workItemId) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/action/ptmData/" + workItemId.toString());
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public Map getBpmWorkItemById(Long workitemId) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/getWorkitemById/" + workitemId);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void closeDataUniformityBacklog(Long workitemId, String actionId, String dataFrom) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", workitemId);
        paramMap.put("actionId", actionId);
        paramMap.put("dataFrom", dataFrom);
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/backlog/closeDataUniformityBacklog");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<String>>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(paramMap), (Object)ex);
            throw ex;
        }
    }

    @Override
    public Map<String, String> queryActivityNameById(List<String> workItemIdList, List<String> backlogIdList) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/backlog/queryNameById");
        HashMap<String, List<String>> reqBody = new HashMap<String, List<String>>();
        reqBody.put("workItemIdList", workItemIdList);
        reqBody.put("backlogIdList", backlogIdList);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity(reqBody, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, String>>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(reqBody), (Object)ex);
            throw ex;
        }
    }

    @Override
    public void sendApiErrorInfoMq(ApiErrorInfoDTO apiErrorInfoDTO) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/devops/sendApiErrorInfoMq");
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity((Object)apiErrorInfoDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, String>>>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)apiErrorInfoDTO), (Object)ex);
            throw ex;
        }
    }

    @Override
    public Boolean operationConfig(String name, Integer operation, String configName) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/config/operationConfig");
        HttpHeaders headers = new HttpHeaders();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("operation", operation);
        params.put("configName", configName);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Boolean>>(){}, new Object[0]);
            return (Boolean)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public ActivityData getTaskData(String backlogId, ExecuteContext pageContext) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/action/edit/" + backlogId) + "?isHistory=" + pageContext.getIsHistory();
        HttpHeaders headers = new HttpHeaders();
        headers.add(ATMC_LOCAL, pageContext.getLocale());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity activityDataResultResponse = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<ActivityData>>(){}, new Object[0]);
            return (ActivityData)((BaseResultDTO)activityDataResultResponse.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public Map getTaskData(String backlogId, Boolean isHistory) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/action/edit/" + backlogId) + "?isHistory=" + isHistory;
        HttpHeaders headers = new HttpHeaders();
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity activityDataResultResponse = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            return (Map)((BaseResultDTO)activityDataResultResponse.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)url, (Object)ex);
            throw ex;
        }
    }

    @Override
    public void signNotice(Integer type, Long backlogId, List<Map<String, Object>> users) {
        String url = this.getWebAtmcReqUrl("api/atmc/v1/backlog/signNotice");
        ImmutableMap paramerMap = ImmutableMap.of((Object)"type", (Object)type, (Object)"backlogId", (Object)backlogId, (Object)"users", users);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity reqEntity = new HttpEntity((Object)paramerMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString((Object)paramerMap), (Object)ex);
            throw ex;
        }
    }

    @Override
    public ExecuteResult executeCalendarAction(SubmitActionDTO submitAction) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/action/calendar/submit");
        return (ExecuteResult)((BaseResultDTO)DwSpringHttpUtil.post((String)url, (Object)submitAction, executeActionResultType)).getResponse();
    }

    @Override
    public ExecuteResult executeAction(SubmitActionDTO submitAction) {
        String url = this.getWebAtmcReqUrl("/api/atmc/v1/action/submit");
        return (ExecuteResult)((BaseResultDTO)DwSpringHttpUtil.post((String)url, (Object)submitAction, executeActionResultType)).getResponse();
    }
}

