/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.audc;

import com.digiwin.athena.aim.sdk.manager.AudcManager;
import com.digiwin.athena.aim.sdk.meta.dto.request.AccessibleReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.AccessibleRespDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.audc.dto.TenantConfigDTO;
import com.digiwin.athena.atdm.audc.dto.UserTrackExtendDTO;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.uibot.dto.UserDefinedCenterMetadataResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class CommonAudcServiceImpl
implements CommonAudcService {
    private static final Logger log = LoggerFactory.getLogger(CommonAudcServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public TenantConfigDTO getTenantConfig(String tenantId, String category) {
        String url = this.envProperties.getAudcUri() + "/api/audc/v1/tenant/config";
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        String finalUrl = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("tenantId", new Object[]{tenantId}).queryParam("category", new Object[]{category}).toUriString();
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(finalUrl, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<TenantConfigDTO>>(){}, new Object[0]);
            return (TenantConfigDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("url: {}, error: ", (Object)finalUrl, (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<UserDefinedCenterMetadataResult> getFieldsSeqByUser(Map<String, Object> paramMap, ExecuteContext executeContext) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.envProperties.getAudcUri() + "/api/audc/v1/userdefined/fieldlist/{pageCode}/{tmProjectId}/{tmActivityId}";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", executeContext.getLocale());
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("proxy_token", authoredUser.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity responseEntity = null;
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<UserDefinedCenterMetadataResult>>>(){}, paramMap);
            return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void reportUserTrack(AuthoredUser authoredUser, List<UserTrackExtendDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String uri = this.envProperties.getAudcUri() + "/api/v1/user/track/report";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());
        try {
            HttpEntity httpEntity = new HttpEntity((Object)JsonUtils.objectToString(list), (MultiValueMap)headers);
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, new Object[0]);
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                ((BaseResultDTO)Objects.requireNonNull(respEntity.getBody())).getResponse();
            } else {
                log.error("exception.audc.report.userTrack.fail", (Object)httpEntity);
            }
        }
        catch (Exception e) {
            log.error("exception.audc.report.userTrack.fail", (Object)e.getMessage());
        }
    }

    @Override
    public List<AccessibleRespDTO> checkTypeActivitiesAccessible(List<String> activityId) {
        if (CollectionUtils.isEmpty(activityId)) {
            return Collections.emptyList();
        }
        ArrayList<AccessibleReqDTO> typeActivitiesList = new ArrayList<AccessibleReqDTO>();
        AccessibleReqDTO accessibleReqDTO = new AccessibleReqDTO();
        accessibleReqDTO.setType("0");
        accessibleReqDTO.setTmActivityIdList(activityId);
        typeActivitiesList.add(accessibleReqDTO);
        return (List)AudcManager.checkAccessible(typeActivitiesList).data();
    }
}

