/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.domain;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.util.StringUtils;

public class ExecuteContext {
    private String locale;
    private String clientAgent;
    private String agentType;
    private Boolean enableSimplifyPack = Boolean.FALSE;
    private String identity;
    private String tmProjectId;
    private String tmActivityId;
    private Long backlogId;
    private String ptmBacklogId;
    private String proxyToken;
    @JsonIgnore
    private AuthoredUser authoredUser;
    private String pageCode;
    private String deviceType;
    private String deviceValue;
    private String pattern;
    private String category;
    private String dataStateCode;
    private String tenantId;
    private Map<String, Object> businessUnit;
    private Map<String, Object> activityParameter;
    private JSONObject settings;
    private String gridSchema;
    private Boolean isHistory;
    private String application;

    public ExecuteContext(String locale, String clientAgent, String identity, String tmProjectId, String tmActivityId, Long backlogId, String proxyToken, AuthoredUser authoredUser, String pageCode, String deviceType, String deviceValue, String pattern, String category, String dataStateCode, String tenantId, Map<String, Object> businessUnit, Map<String, Object> activityParameter, JSONObject settings) {
        this.locale = locale;
        this.clientAgent = clientAgent;
        this.identity = identity;
        this.tmProjectId = tmProjectId;
        this.tmActivityId = tmActivityId;
        this.backlogId = backlogId;
        this.proxyToken = proxyToken;
        this.authoredUser = authoredUser;
        this.pageCode = pageCode;
        this.deviceType = deviceType;
        this.deviceValue = deviceValue;
        this.pattern = pattern;
        this.category = category;
        this.dataStateCode = dataStateCode;
        this.tenantId = tenantId;
        this.businessUnit = businessUnit;
        this.activityParameter = activityParameter;
        this.settings = settings;
    }

    public ExecuteContext appendHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        this.setClientAgent(clientAgent);
        this.setLocale(locale);
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        this.setAuthoredUser(authoredUser);
        this.setTenantId(authoredUser.getTenantId());
        return this;
    }

    public ExecuteContext appendExtend(JSONObject settings) {
        this.settings = settings;
        return this;
    }

    public ExecuteContext appendExecuteContext(ExecuteContext executeContext) {
        this.setClientAgent(executeContext.getClientAgent());
        this.setLocale(executeContext.getLocale());
        this.setAuthoredUser(executeContext.getAuthoredUser());
        return this;
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request) {
        AuthoredUser authoredUser;
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        if ((authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-proxy-auth-user-data")) == null) {
            authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        }
        ExecuteContext executeContext = ExecuteContext.builder().clientAgent(clientAgent).locale(locale).authoredUser(authoredUser).tenantId(authoredUser.getTenantId()).build();
        return executeContext;
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request, String pageCode, String tmProjectId, String tmActivityId) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        ExecuteContext executeContext = ExecuteContext.builder().clientAgent(clientAgent).locale(locale).authoredUser(authoredUser).tenantId(authoredUser.getTenantId()).pageCode(pageCode).tmActivityId(tmActivityId).tmProjectId(tmProjectId).build();
        return executeContext;
    }

    public static ExecuteContext fromSubmitExecuteContent(SubmitExecuteContext submitExecuteContext) {
        ExecuteContext executeContext = ExecuteContext.builder().locale(submitExecuteContext.getLocale()).clientAgent(submitExecuteContext.getClientAgent()).identity(null).tmProjectId(submitExecuteContext.getTmProjectId()).tmActivityId(submitExecuteContext.getTmActivityId()).proxyToken(submitExecuteContext.getProxyToken()).authoredUser(submitExecuteContext.getAuthoredUser()).pageCode(submitExecuteContext.getPageCode()).deviceType(submitExecuteContext.getDeviceType()).deviceValue(null).pattern(submitExecuteContext.getPattern()).category(submitExecuteContext.getCategory()).tenantId(submitExecuteContext.getTenantId()).businessUnit(submitExecuteContext.getBusinessUnit()).activityParameter(null).backlogId(submitExecuteContext.getBacklogId()).build();
        return executeContext;
    }

    public static ExecuteContextBuilder builder() {
        return new ExecuteContextBuilder();
    }

    public String getLocale() {
        return this.locale;
    }

    public String getClientAgent() {
        return this.clientAgent;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public Boolean getEnableSimplifyPack() {
        return this.enableSimplifyPack;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getTmProjectId() {
        return this.tmProjectId;
    }

    public String getTmActivityId() {
        return this.tmActivityId;
    }

    public Long getBacklogId() {
        return this.backlogId;
    }

    public String getPtmBacklogId() {
        return this.ptmBacklogId;
    }

    public String getProxyToken() {
        return this.proxyToken;
    }

    public AuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    public String getPageCode() {
        return this.pageCode;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceValue() {
        return this.deviceValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDataStateCode() {
        return this.dataStateCode;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Map<String, Object> getBusinessUnit() {
        return this.businessUnit;
    }

    public Map<String, Object> getActivityParameter() {
        return this.activityParameter;
    }

    public JSONObject getSettings() {
        return this.settings;
    }

    public String getGridSchema() {
        return this.gridSchema;
    }

    public Boolean getIsHistory() {
        return this.isHistory;
    }

    public String getApplication() {
        return this.application;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public void setEnableSimplifyPack(Boolean enableSimplifyPack) {
        this.enableSimplifyPack = enableSimplifyPack;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setTmProjectId(String tmProjectId) {
        this.tmProjectId = tmProjectId;
    }

    public void setTmActivityId(String tmActivityId) {
        this.tmActivityId = tmActivityId;
    }

    public void setBacklogId(Long backlogId) {
        this.backlogId = backlogId;
    }

    public void setPtmBacklogId(String ptmBacklogId) {
        this.ptmBacklogId = ptmBacklogId;
    }

    public void setProxyToken(String proxyToken) {
        this.proxyToken = proxyToken;
    }

    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceValue(String deviceValue) {
        this.deviceValue = deviceValue;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setDataStateCode(String dataStateCode) {
        this.dataStateCode = dataStateCode;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setBusinessUnit(Map<String, Object> businessUnit) {
        this.businessUnit = businessUnit;
    }

    public void setActivityParameter(Map<String, Object> activityParameter) {
        this.activityParameter = activityParameter;
    }

    public void setSettings(JSONObject settings) {
        this.settings = settings;
    }

    public void setGridSchema(String gridSchema) {
        this.gridSchema = gridSchema;
    }

    public void setIsHistory(Boolean isHistory) {
        this.isHistory = isHistory;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecuteContext)) {
            return false;
        }
        ExecuteContext other = (ExecuteContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$clientAgent = this.getClientAgent();
        String other$clientAgent = other.getClientAgent();
        if (this$clientAgent == null ? other$clientAgent != null : !this$clientAgent.equals(other$clientAgent)) {
            return false;
        }
        String this$agentType = this.getAgentType();
        String other$agentType = other.getAgentType();
        if (this$agentType == null ? other$agentType != null : !this$agentType.equals(other$agentType)) {
            return false;
        }
        Boolean this$enableSimplifyPack = this.getEnableSimplifyPack();
        Boolean other$enableSimplifyPack = other.getEnableSimplifyPack();
        if (this$enableSimplifyPack == null ? other$enableSimplifyPack != null : !((Object)this$enableSimplifyPack).equals(other$enableSimplifyPack)) {
            return false;
        }
        String this$identity = this.getIdentity();
        String other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        String this$tmProjectId = this.getTmProjectId();
        String other$tmProjectId = other.getTmProjectId();
        if (this$tmProjectId == null ? other$tmProjectId != null : !this$tmProjectId.equals(other$tmProjectId)) {
            return false;
        }
        String this$tmActivityId = this.getTmActivityId();
        String other$tmActivityId = other.getTmActivityId();
        if (this$tmActivityId == null ? other$tmActivityId != null : !this$tmActivityId.equals(other$tmActivityId)) {
            return false;
        }
        Long this$backlogId = this.getBacklogId();
        Long other$backlogId = other.getBacklogId();
        if (this$backlogId == null ? other$backlogId != null : !((Object)this$backlogId).equals(other$backlogId)) {
            return false;
        }
        String this$ptmBacklogId = this.getPtmBacklogId();
        String other$ptmBacklogId = other.getPtmBacklogId();
        if (this$ptmBacklogId == null ? other$ptmBacklogId != null : !this$ptmBacklogId.equals(other$ptmBacklogId)) {
            return false;
        }
        String this$proxyToken = this.getProxyToken();
        String other$proxyToken = other.getProxyToken();
        if (this$proxyToken == null ? other$proxyToken != null : !this$proxyToken.equals(other$proxyToken)) {
            return false;
        }
        AuthoredUser this$authoredUser = this.getAuthoredUser();
        AuthoredUser other$authoredUser = other.getAuthoredUser();
        if (this$authoredUser == null ? other$authoredUser != null : !this$authoredUser.equals(other$authoredUser)) {
            return false;
        }
        String this$pageCode = this.getPageCode();
        String other$pageCode = other.getPageCode();
        if (this$pageCode == null ? other$pageCode != null : !this$pageCode.equals(other$pageCode)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$deviceValue = this.getDeviceValue();
        String other$deviceValue = other.getDeviceValue();
        if (this$deviceValue == null ? other$deviceValue != null : !this$deviceValue.equals(other$deviceValue)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$dataStateCode = this.getDataStateCode();
        String other$dataStateCode = other.getDataStateCode();
        if (this$dataStateCode == null ? other$dataStateCode != null : !this$dataStateCode.equals(other$dataStateCode)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Map<String, Object> this$businessUnit = this.getBusinessUnit();
        Map<String, Object> other$businessUnit = other.getBusinessUnit();
        if (this$businessUnit == null ? other$businessUnit != null : !((Object)this$businessUnit).equals(other$businessUnit)) {
            return false;
        }
        Map<String, Object> this$activityParameter = this.getActivityParameter();
        Map<String, Object> other$activityParameter = other.getActivityParameter();
        if (this$activityParameter == null ? other$activityParameter != null : !((Object)this$activityParameter).equals(other$activityParameter)) {
            return false;
        }
        JSONObject this$settings = this.getSettings();
        JSONObject other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !this$settings.equals(other$settings)) {
            return false;
        }
        String this$gridSchema = this.getGridSchema();
        String other$gridSchema = other.getGridSchema();
        if (this$gridSchema == null ? other$gridSchema != null : !this$gridSchema.equals(other$gridSchema)) {
            return false;
        }
        Boolean this$isHistory = this.getIsHistory();
        Boolean other$isHistory = other.getIsHistory();
        if (this$isHistory == null ? other$isHistory != null : !((Object)this$isHistory).equals(other$isHistory)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        return !(this$application == null ? other$application != null : !this$application.equals(other$application));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecuteContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $clientAgent = this.getClientAgent();
        result = result * 59 + ($clientAgent == null ? 43 : $clientAgent.hashCode());
        String $agentType = this.getAgentType();
        result = result * 59 + ($agentType == null ? 43 : $agentType.hashCode());
        Boolean $enableSimplifyPack = this.getEnableSimplifyPack();
        result = result * 59 + ($enableSimplifyPack == null ? 43 : ((Object)$enableSimplifyPack).hashCode());
        String $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        String $tmProjectId = this.getTmProjectId();
        result = result * 59 + ($tmProjectId == null ? 43 : $tmProjectId.hashCode());
        String $tmActivityId = this.getTmActivityId();
        result = result * 59 + ($tmActivityId == null ? 43 : $tmActivityId.hashCode());
        Long $backlogId = this.getBacklogId();
        result = result * 59 + ($backlogId == null ? 43 : ((Object)$backlogId).hashCode());
        String $ptmBacklogId = this.getPtmBacklogId();
        result = result * 59 + ($ptmBacklogId == null ? 43 : $ptmBacklogId.hashCode());
        String $proxyToken = this.getProxyToken();
        result = result * 59 + ($proxyToken == null ? 43 : $proxyToken.hashCode());
        AuthoredUser $authoredUser = this.getAuthoredUser();
        result = result * 59 + ($authoredUser == null ? 43 : $authoredUser.hashCode());
        String $pageCode = this.getPageCode();
        result = result * 59 + ($pageCode == null ? 43 : $pageCode.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $deviceValue = this.getDeviceValue();
        result = result * 59 + ($deviceValue == null ? 43 : $deviceValue.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $dataStateCode = this.getDataStateCode();
        result = result * 59 + ($dataStateCode == null ? 43 : $dataStateCode.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Map<String, Object> $businessUnit = this.getBusinessUnit();
        result = result * 59 + ($businessUnit == null ? 43 : ((Object)$businessUnit).hashCode());
        Map<String, Object> $activityParameter = this.getActivityParameter();
        result = result * 59 + ($activityParameter == null ? 43 : ((Object)$activityParameter).hashCode());
        JSONObject $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : $settings.hashCode());
        String $gridSchema = this.getGridSchema();
        result = result * 59 + ($gridSchema == null ? 43 : $gridSchema.hashCode());
        Boolean $isHistory = this.getIsHistory();
        result = result * 59 + ($isHistory == null ? 43 : ((Object)$isHistory).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        return result;
    }

    public String toString() {
        return "ExecuteContext(locale=" + this.getLocale() + ", clientAgent=" + this.getClientAgent() + ", agentType=" + this.getAgentType() + ", enableSimplifyPack=" + this.getEnableSimplifyPack() + ", identity=" + this.getIdentity() + ", tmProjectId=" + this.getTmProjectId() + ", tmActivityId=" + this.getTmActivityId() + ", backlogId=" + this.getBacklogId() + ", ptmBacklogId=" + this.getPtmBacklogId() + ", proxyToken=" + this.getProxyToken() + ", authoredUser=" + this.getAuthoredUser() + ", pageCode=" + this.getPageCode() + ", deviceType=" + this.getDeviceType() + ", deviceValue=" + this.getDeviceValue() + ", pattern=" + this.getPattern() + ", category=" + this.getCategory() + ", dataStateCode=" + this.getDataStateCode() + ", tenantId=" + this.getTenantId() + ", businessUnit=" + this.getBusinessUnit() + ", activityParameter=" + this.getActivityParameter() + ", settings=" + this.getSettings() + ", gridSchema=" + this.getGridSchema() + ", isHistory=" + this.getIsHistory() + ", application=" + this.getApplication() + ")";
    }

    public ExecuteContext(String locale, String clientAgent, String agentType, Boolean enableSimplifyPack, String identity, String tmProjectId, String tmActivityId, Long backlogId, String ptmBacklogId, String proxyToken, AuthoredUser authoredUser, String pageCode, String deviceType, String deviceValue, String pattern, String category, String dataStateCode, String tenantId, Map<String, Object> businessUnit, Map<String, Object> activityParameter, JSONObject settings, String gridSchema, Boolean isHistory, String application) {
        this.locale = locale;
        this.clientAgent = clientAgent;
        this.agentType = agentType;
        this.enableSimplifyPack = enableSimplifyPack;
        this.identity = identity;
        this.tmProjectId = tmProjectId;
        this.tmActivityId = tmActivityId;
        this.backlogId = backlogId;
        this.ptmBacklogId = ptmBacklogId;
        this.proxyToken = proxyToken;
        this.authoredUser = authoredUser;
        this.pageCode = pageCode;
        this.deviceType = deviceType;
        this.deviceValue = deviceValue;
        this.pattern = pattern;
        this.category = category;
        this.dataStateCode = dataStateCode;
        this.tenantId = tenantId;
        this.businessUnit = businessUnit;
        this.activityParameter = activityParameter;
        this.settings = settings;
        this.gridSchema = gridSchema;
        this.isHistory = isHistory;
        this.application = application;
    }

    public ExecuteContext() {
    }

    public static class ExecuteContextBuilder {
        private String locale;
        private String clientAgent;
        private String agentType;
        private Boolean enableSimplifyPack;
        private String identity;
        private String tmProjectId;
        private String tmActivityId;
        private Long backlogId;
        private String ptmBacklogId;
        private String proxyToken;
        private AuthoredUser authoredUser;
        private String pageCode;
        private String deviceType;
        private String deviceValue;
        private String pattern;
        private String category;
        private String dataStateCode;
        private String tenantId;
        private Map<String, Object> businessUnit;
        private Map<String, Object> activityParameter;
        private JSONObject settings;
        private String gridSchema;
        private Boolean isHistory;
        private String application;

        ExecuteContextBuilder() {
        }

        public ExecuteContextBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public ExecuteContextBuilder clientAgent(String clientAgent) {
            this.clientAgent = clientAgent;
            return this;
        }

        public ExecuteContextBuilder agentType(String agentType) {
            this.agentType = agentType;
            return this;
        }

        public ExecuteContextBuilder enableSimplifyPack(Boolean enableSimplifyPack) {
            this.enableSimplifyPack = enableSimplifyPack;
            return this;
        }

        public ExecuteContextBuilder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public ExecuteContextBuilder tmProjectId(String tmProjectId) {
            this.tmProjectId = tmProjectId;
            return this;
        }

        public ExecuteContextBuilder tmActivityId(String tmActivityId) {
            this.tmActivityId = tmActivityId;
            return this;
        }

        public ExecuteContextBuilder backlogId(Long backlogId) {
            this.backlogId = backlogId;
            return this;
        }

        public ExecuteContextBuilder ptmBacklogId(String ptmBacklogId) {
            this.ptmBacklogId = ptmBacklogId;
            return this;
        }

        public ExecuteContextBuilder proxyToken(String proxyToken) {
            this.proxyToken = proxyToken;
            return this;
        }

        public ExecuteContextBuilder authoredUser(AuthoredUser authoredUser) {
            this.authoredUser = authoredUser;
            return this;
        }

        public ExecuteContextBuilder pageCode(String pageCode) {
            this.pageCode = pageCode;
            return this;
        }

        public ExecuteContextBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public ExecuteContextBuilder deviceValue(String deviceValue) {
            this.deviceValue = deviceValue;
            return this;
        }

        public ExecuteContextBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public ExecuteContextBuilder category(String category) {
            this.category = category;
            return this;
        }

        public ExecuteContextBuilder dataStateCode(String dataStateCode) {
            this.dataStateCode = dataStateCode;
            return this;
        }

        public ExecuteContextBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ExecuteContextBuilder businessUnit(Map<String, Object> businessUnit) {
            this.businessUnit = businessUnit;
            return this;
        }

        public ExecuteContextBuilder activityParameter(Map<String, Object> activityParameter) {
            this.activityParameter = activityParameter;
            return this;
        }

        public ExecuteContextBuilder settings(JSONObject settings) {
            this.settings = settings;
            return this;
        }

        public ExecuteContextBuilder gridSchema(String gridSchema) {
            this.gridSchema = gridSchema;
            return this;
        }

        public ExecuteContextBuilder isHistory(Boolean isHistory) {
            this.isHistory = isHistory;
            return this;
        }

        public ExecuteContextBuilder application(String application) {
            this.application = application;
            return this;
        }

        public ExecuteContext build() {
            return new ExecuteContext(this.locale, this.clientAgent, this.agentType, this.enableSimplifyPack, this.identity, this.tmProjectId, this.tmActivityId, this.backlogId, this.ptmBacklogId, this.proxyToken, this.authoredUser, this.pageCode, this.deviceType, this.deviceValue, this.pattern, this.category, this.dataStateCode, this.tenantId, this.businessUnit, this.activityParameter, this.settings, this.gridSchema, this.isHistory, this.application);
        }

        public String toString() {
            return "ExecuteContext.ExecuteContextBuilder(locale=" + this.locale + ", clientAgent=" + this.clientAgent + ", agentType=" + this.agentType + ", enableSimplifyPack=" + this.enableSimplifyPack + ", identity=" + this.identity + ", tmProjectId=" + this.tmProjectId + ", tmActivityId=" + this.tmActivityId + ", backlogId=" + this.backlogId + ", ptmBacklogId=" + this.ptmBacklogId + ", proxyToken=" + this.proxyToken + ", authoredUser=" + this.authoredUser + ", pageCode=" + this.pageCode + ", deviceType=" + this.deviceType + ", deviceValue=" + this.deviceValue + ", pattern=" + this.pattern + ", category=" + this.category + ", dataStateCode=" + this.dataStateCode + ", tenantId=" + this.tenantId + ", businessUnit=" + this.businessUnit + ", activityParameter=" + this.activityParameter + ", settings=" + this.settings + ", gridSchema=" + this.gridSchema + ", isHistory=" + this.isHistory + ", application=" + this.application + ")";
        }
    }
}

