/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.smartdata;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.DataUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.smartdata.dto.RetractCompareReqDTO;
import com.digiwin.athena.atdm.util.UriUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonSmartDataServiceImpl
implements CommonSmartDataService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CommonSmartDataServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    private String dataComparisonHttpHost;
    private String executionEngineHttpHost;
    private String dataFootPrintHttpHost;

    public void afterPropertiesSet() throws Exception {
        this.dataComparisonHttpHost = UriUtils.parseHttpHost(this.envProperties.getDataComparisonUri());
        this.dataFootPrintHttpHost = UriUtils.parseHttpHost(this.envProperties.getDataFootPrintUri());
        this.executionEngineHttpHost = UriUtils.parseHttpHost(this.envProperties.getExecutionEngineUri());
    }

    @Override
    public HashMap<String, Object> execute(String tenantId, Action action) {
        String url = this.executionEngineHttpHost + "/restful/service/ExecutionEngine/execute";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", tenantId);
        body.put("actionId", action.getActionId());
        Optional optionalStringObjectMap = DataUtils.mergeMap((Map[])new Map[]{action.getParas()});
        optionalStringObjectMap.ifPresent(stringObjectMap -> body.put("param", stringObjectMap));
        body.put("eocMap", action.getBusinessUnit());
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<HashMap<String, Object>>>(){}, new Object[0]);
            return (HashMap)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("[execute] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)e);
            throw e;
        }
    }

    @Override
    public HashMap<String, Object> execute(String tenantId, String actionId, Map<String, Object> paras, Map eoc, Map extendedFields) {
        String url = this.executionEngineHttpHost + "/restful/service/ExecutionEngine/execute";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", tenantId);
        body.put("actionId", actionId);
        body.put("param", paras);
        body.put("eocMap", eoc);
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        this.setHeaderAppCode(extendedFields, headerMap);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            Object response = ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            if (response instanceof List) {
                List respList = (List)response;
                if (CollectionUtils.isNotEmpty((Collection)respList)) {
                    return (HashMap)respList.get(0);
                }
                return null;
            }
            if (response instanceof Map) {
                return (HashMap)response;
            }
            return null;
        }
        catch (Exception e) {
            log.error("[execute] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)e);
            throw e;
        }
    }

    @Override
    public Object executeWithParas(String tenantId, String actionId, Map[] paras, Map eoc, Map extendedFields) {
        String url = this.executionEngineHttpHost + "/restful/service/ExecutionEngine/execute";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", tenantId);
        body.put("actionId", actionId);
        body.put("paras", paras);
        body.put("eocMap", eoc);
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        if (extendedFields != null && extendedFields.containsKey("traceId") && extendedFields.get("traceId") != null) {
            headerMap.add("digi-dap-service-chain-info", MessageFormat.format("0,0:ScheduleManager^{0}", extendedFields.get("traceId")));
        }
        this.setHeaderAppCode(extendedFields, headerMap);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("[executeWithParas] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)e);
            throw e;
        }
    }

    @Override
    public Object executeForManualProject(String tenantId, String actionId, Map[] paras, Map eocInfo, Map extendedFields) {
        String url = this.executionEngineHttpHost + "/restful/service/ExecutionEngine/execute";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", tenantId);
        body.put("actionId", actionId);
        body.put("paras", paras);
        body.put("eocMap", eocInfo);
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        this.setHeaderAppCode(extendedFields, headerMap);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("[executeForManualProject] body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)e);
            throw e;
        }
    }

    private void setHeaderAppCode(Map<String, Object> extendedFields, HttpHeaders headerMap) {
        if (extendedFields != null) {
            Object application = extendedFields.get("application");
            if (Objects.nonNull(application)) {
                headerMap.add("application", application.toString());
            }
            String taskCode = Optional.ofNullable(extendedFields.get("tmActivityId")).map(Object::toString).orElse(null);
            String taskType = Optional.ofNullable(extendedFields.get("pageCode")).map(Object::toString).map(pageCode -> {
                switch (pageCode) {
                    case "task-card": 
                    case "task-detail": {
                        return "TASK";
                    }
                    case "basic-data": 
                    case "browse-page": 
                    case "edit-page": {
                        return "DATA_ENTRY";
                    }
                }
                return null;
            }).orElse(null);
            if (StringUtils.isNotBlank((String)taskType) && StringUtils.isNotBlank((String)taskCode)) {
                headerMap.add("taskType", taskType);
                headerMap.add("taskCode", taskCode);
            }
        }
    }

    @Override
    public Object clearFootprintData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, Object> eocMap, List<Map> bkList) {
        String uri = this.dataFootPrintHttpHost + "/restful/service/DataFootprint/activity/stop";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", user.getTenantId());
        body.put("eocId", eocMap);
        ArrayList bkInfoList = new ArrayList();
        for (Map bkMap : bkList) {
            HashMap<String, Object> bkInfo = new HashMap<String, Object>();
            bkInfo.put("entityName", entityName);
            bkInfo.put("bk", bkMap);
            bkInfoList.add(bkInfo);
        }
        body.put("bkInfo", bkInfoList);
        body.put("actInsId", instanceId);
        body.put("actTmpId", activityCode);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(body), (Object)ex);
            throw ex;
        }
    }

    @Override
    public Object clearComparisonData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, Object> eocMap, List<Map> bkList) {
        String uri = this.dataComparisonHttpHost + "/restful/standard/datacomparison/comparison/v1/stop";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", user.getTenantId());
        body.put("eocMap", eocMap);
        body.put("instanceId", instanceId);
        body.put("tempId", activityCode);
        body.put("bks", bkList);
        body.put("entityName", entityName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("clearComparisonData: {}, url: {}, error: ", new Object[]{JsonUtils.objectToString(body), uri, ex});
            throw ex;
        }
    }

    @Override
    public void retractComparisonData(RetractCompareReqDTO retractCompareReqDTO) {
        log.info("retractComparisonData:{}", (Object)retractCompareReqDTO);
        String uri = this.dataComparisonHttpHost + "/restful/standard/datacomparison/comparison/v1/retract";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)retractCompareReqDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("retractComparisonData: {}, url: {}, error: ", new Object[]{retractCompareReqDTO, uri, ex});
            throw ex;
        }
    }

    @Override
    public Object recoverComparisonData(Map<String, Object> paramMap) {
        log.info("recoverComparisonData:{}", paramMap);
        String uri = this.dataComparisonHttpHost + "/restful/standard/datacomparison/comparison/v1/recover";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(paramMap), (Object)e);
            throw e;
        }
    }

    @Override
    public Object giveupComparisonData(Map<String, Object> paramMap) {
        log.info("giveupComparisonData:{}", paramMap);
        String uri = this.dataComparisonHttpHost + "/restful/standard/datacomparison/comparison/v1/giveup";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(paramMap), (Object)e);
            throw e;
        }
    }

    @Override
    public boolean existsComparison(Map<String, Object> paramMap) {
        log.info("existsComparison:{}", paramMap);
        String uri = this.dataComparisonHttpHost + "/restful/standard/datacomparison/comparison/v1/exists";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            boolean exist = false;
            if (((BaseResultDTO)respEntity.getBody()).getResponseWithException("") != null) {
                exist = Boolean.valueOf(((BaseResultDTO)respEntity.getBody()).getResponse().toString());
            }
            return exist;
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(paramMap), (Object)e);
            throw e;
        }
    }

    @Override
    public Object batchGiveupComparisonData(Map<String, Object> paramMap) {
        log.info("batchGiveupComparisonData:{}", paramMap);
        String uri = this.dataComparisonHttpHost + "/restful/standard/datacomparison/comparison/v1/batch/giveup";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            return ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(paramMap), (Object)e);
            throw e;
        }
    }
}

