package com.digiwin.athena.atdm.datasource.domain;


import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Action实体定义
 * @author zhujg
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SubmitAction extends Action {

    /**
     * 前端定义的ID
     *  confirm:提交 cancel 取消
     */
    private String id;

    /**
     * 前端定义的UI 类型使用到
     */
    private List<Object> backFills;

    private String url;

    /**
     * 默认ACTION
     */
    private boolean defaultAction;

    /**
     * 执行上下文
     */
    private SubmitExecuteContext executeContext;


    /**
     * 扩展参数，在需要做额外处理时可以使用
     * "extendParas": {
     *      // 关键字
     *     "dataKeys": "requisitions_no;requisitions_seq",
     *     // 流程变量
     *     "processVariableName": "requisitions_info",
     *     // 提交变量的单头字段
     *     "submitVariableName": "requisitions_info",
     *     // 提交变量的单身字段
     *     "detailField": "requisitions_info"
     * }
     */
    private Map<String,Object> extendParas;

    /**
     * 批量提交
     *   "isBatch": true,
     *   "schema": "purchase"
     */
    private Map<String,Object> batch;
    /**
     * 目标状态
     */
    private String targetDataState;
    /**
     * 执行按扭时前端 执行的脚本
     */
    private String actionScript;

    private Object returnText;

    /**
     * 判断是否结束
     */
    private DataSourceDTO checkCompleteAction;

    /**
     * 在任务结束之后才执行
     */
    private Boolean executeAfterCheckCompleted;

    /**
     * 提交API 缺失显示字段
     */
    private List<Map<String,String>> addShowFileds;


    /**
     * 签核-可退回的任务ID列表
     */
    private List<String> startApproveActivity;

    /**
     * 要执行的附加Action，可以为null
     */
    private List<SubmitAction> attachActions;

    /**
     *  workitemid 对应的提交请求ptm的入餐
     */
    private Map<Long,Map<String,Object>> workItemToBpmParas;

    /**
     * 提交数据 特殊处理
     */
    private List<SubmitProcessor> submitProcessors;

    /**
     * 按钮显示顺序，数字越小越显示在页面右侧
     */
    private Integer order;


    /**
     * 提交的数据schema集合，不指定表示提交全部数据
     * <br>指定后，提交时只提交指定的数据
     */
    private List<String> submitSchemas;

//    /**
//     * 是否模拟执行，如果为true，不会真正地执行，
//     * 用于合并任务的第一次模拟执行
//     * 目前只针对 start-new-process 这个action
//     */
//    private Boolean mockExecute;

    @JsonIgnore
    private SubmitAction mergeDataAction;

    /**
     *  当前api执行情况，是否执行过当前api,true代表当前api已经执行过，用来进行构造之前的参数，进行执行下一步
     */
    @JsonIgnore
    private boolean executeAction;
    /**
     *  发送事件
     */
    @JsonIgnore
    private boolean executeEventPost;

    @JsonIgnore
    private List<String> ACTION_LIST = Arrays.asList("dispatch","reexecute","agree","disagree","reassign","reapprove","add-task","terminate-task");

    // TODO 容错 test coode
    public <T, V, K> SubmitAction(String id, List<T> value, String url, boolean b, Object o, HashMap<K,V> kvHashMap, HashMap<K,V> kvHashMap1, String targetDataState, String actionScript, String returnText, DataSourceDTO dataSourceDTO, boolean b1, List<T> asList, List<T> value1, List<T> asList1, List<T> asList2, int i, List<T> value2, Object o1, List<T> value3, SubmitType submitType, Object o2, Object o3, Object o4) {
    }

    /**
     * 提交的数据源是什么
     *   "isBatch": true,
     *   "schema": "purchase"
     */
    private SubmitType submitType;

    /**
     * action执行结果
     */
    private ExecuteResult executeResult;

    /**
     * action是否执行过
     */
    private Boolean executed;
    /**
     * action是否支持重试
     */
    private Boolean supportRetry;

    private List<SubmitAction> actionList;


    /**
     *  业务熟悉字段
     */
    private BusinessConfig businessConfig;

    @Override
    public String toString(){
        return String.format("%s ----- %s ----  %s",id,getActionId(),returnText);
    }

    /**
     * 是否是bpm的 派送关卡
     * @return
     */
    @JsonIgnore
    public boolean isDispatchAction(){
        if (UiBotConstants.ACTION_CATEGORY_TASK_ENGINE.equals(this.getCategory())
                && ACTION_LIST.contains(this.getServiceId().getName())) {
            //是taskEngine且是dispatch
            return true;
        }
        else if (UiBotConstants.ACTION_CATEGORY_BPM.equals(this.getCategory())) {
            // 是 flowEngine，流程引擎
            return true;
        }else if(UiBotConstants.ACTION_CATEGORY_WORKFLOW.equals(this.getCategory())){
            // 工作流的api都是直接关卡的，如果为false会导致收不到关卡的消息，卡未关
            return true;

        }
        return false;
    }
}
