package com.digiwin.athena.atdm.activity.domain;

import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class TmActionBase {

    /**
     * 序号
     */
    private int sequence;

    /**
     * 数据源 名称
     */
    private String name;

    /**
     * 数据源返回的结果集中数据主键
     */
    private List<String> dataKeys;

    /**
     * 显示名称
     */
    private String title;

    /**
     * 服务类型
     * 1.ESP
     */
    private String type;


    /**
     * 数据源ID
     */
    private String actionId;


    /**
     * 服务名称
     */
    private String serviceName;

    /**
     * 服务执行URL
     */
    private String url;

    /**
     * 是否代理
     */
    private Boolean needProxyToken;

    /**
     * ESP 使用的产品名称
     */
    private String productName;

    /**
     * API 入参 参数转换设定
     */
    private List<ActionParameterMapping> actionParams;

    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String,Object> extendParas;


}
