package com.digiwin.athena.atdm.bpm;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Slf4j
@Service
public class CommonBpmServiceImpl implements CommonBpmService {

    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void execute(Action action) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();

        if (serviceId != null && StringUtils.hasText(serviceId.getProxyToken())) {
            headerMap.add(GlobalConstant.IAM_USER_TOKEN, serviceId.getProxyToken());
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, serviceId.getProxyToken());
        }
        String serviceUri = (null == serviceId)?"" : serviceId.getServiceUri();
        if(!serviceUri.startsWith(envProperties.getBpmUri())){
            serviceUri = envProperties.getBpmUri() + ((null == serviceId)?"" : serviceId.getServiceUri());
        }

//        log.info("[执行流程引擎]：uri：{}，header：{}，body：{}", serviceId, JsonUtils.objectToString(headerMap), JsonUtils.objectToString(action.getParas()));

        try {
            HttpEntity httpEntity = new HttpEntity<Map>(action.getParas(), headerMap);
            ResponseEntity<Map> responseEntity = restTemplate.postForEntity(serviceUri, httpEntity, Map.class);
            if (responseEntity.getBody() != null) {
                Map result = responseEntity.getBody();
                if (!"200".equals(result.get("status").toString())) {
                    String message = String.format(messageUtils.getMessage("exception.execution.bpm.api.fail"),
                            result.get("errorMessage"), serviceUri, action.getParas());
                    String errorCode = MapUtil.getStr(result, "errorCode", "");
                    throw BusinessException.create(errorCode, message);
                }
            }
        } catch (BusinessException ex) {
            log.error("body: {}, error: ", JsonUtils.objectToString(action.getParas()), ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("body: {}, error: ", JsonUtils.objectToString(action.getParas()), ex);
            throw ex;
//            String message = String.format(messageUtils.getMessage("exception.execution.bpm.api.fail2"),
//                    serviceUri, action.getParas(), ex.getMessage());
//
//            throw BusinessException.create(message);
        }
    }
}
