package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.activity.domain.TmActivityDefinition;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.thememap.dto.ActionInfo;
import com.digiwin.athena.atdm.thememap.dto.BaseItemDto;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanDTO;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanItemsDTO;
import com.digiwin.athena.atdm.thememap.dto.TmAppDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class CommonThemeMapServiceImpl implements CommonThemeMapService {

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    public HashMap<String,Object> executeFormula(String formulaId){

        String uri = envProperties.getKnowledgeGraphUri()+"/restful/service/knowledgegraph/tenantSettings/formula?formulaId={formulaId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String, String> param = new HashMap<>();
        param.put("formulaId",formulaId);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            return ( HashMap<String,Object>) responseEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("url: {}, error: ", uri, ex);
            throw ex;
        }
    }

    public  HashMap<String,Object> post(String uri,Map parameter){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        HttpEntity httpEntity = new HttpEntity<Map>(parameter,headers);
        try {
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });

            Object response = responseEntity.getBody().getResponseWithException("");
            if (response instanceof Map) {
                return (HashMap) response;
            } else if (response instanceof List) {
                List respList = (List) response;
                if (CollectionUtils.isNotEmpty(respList)) {
                    return (HashMap<String, Object>) respList.get(0);
                } else {
                    return null;
                }
            } else {
                return null;
            }
        } catch (Exception ex) {
            log.error("body: {}, error: ", JsonUtils.objectToString(parameter), ex);
            throw ex;
        }
    }

    public HashMap<String,Object> postByRelativeUri(String relativeUri,Map parameter){

        String uri = envProperties.getWebThemeMapUri() +"/restful/service/" + relativeUri;
        return post(uri,parameter);
    }


    /**
     * 获取方案数据
     * @return
     */
    @Override
    public List<SuggestPlanItemsDTO> getSuggestPlan(String locale, String decisionCode, List<Map<String,Object>> data){
        String url=envProperties.getDataMapUri()+"/restful/standard/datamap/mechanismEngine/sourceData";
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale",locale);
        HashMap<String,Object> body = new HashMap();
        body.put("type","decision");
        body.put("code",decisionCode);
        body.put("datas",data);
        HttpEntity<HashMap<String,Object>> requestEntity = new HttpEntity<>(body, headers);

        try {
            ResponseEntity<BaseResultDTO<SuggestPlanDTO>> responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<SuggestPlanDTO>>() {
                    });
            if (responseEntity.getBody().getResponseWithException("")==null){
                log.warn(url+"返回null");
                return null;
            }
            return responseEntity.getBody().getResponseWithException("").getSuggest();
        }catch (Exception ex) {
            //吃掉异常
            log.error("body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;
        }
    }

    /**
     * 获取TM 活动的定义
     * @param pageContext
     * @return
     */
    public TmActivity getActivityAction(ExecuteContext pageContext){
        String url=envProperties.getKnowledgeGraphUri()+"/restful/service/knowledgegraph/task/activityDefinition?taskId="+pageContext.getTmProjectId()+"&activityId="+pageContext.getTmActivityId()+"&pageCode="+pageContext.getPageCode();
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale",pageContext.getLocale());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<TmActivityDefinition> responseEntity =restTemplate.exchange(url, HttpMethod.GET, requestEntity, TmActivityDefinition.class);
            TmActivity tmActivity = responseEntity.getBody().getResponseWithException(messageUtils.getMessage("exception.KG.find.activity.define2"));
            setTmActivityValue(tmActivity);
            return tmActivity;
        }catch (Exception e) {
            log.error("url: {}, error: ", url, e);
            throw e;
        }
    }


    /**
     * 设置 数据源name 值
     * @param tmActivity
     */
    private void setTmActivityValue(TmActivity tmActivity){
        if(MapUtils.isEmpty(tmActivity.getDataSources())){
            return;
        }
        tmActivity.getDataSources().forEach((k,v)->{
            if(StringUtils.isBlank(v.getName())){
                v.setName(k);
            }
        });
    }

   // @Override
    public List<BaseItemDto> getActivitiesByPattern(String pattern){

        String url=envProperties.getDataMapUri()+"/restful/standard/datamap/record/activitiesAndSortByPattern?pattern={pattern}";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map<String,Object> param = new HashMap();
        param.put("pattern", pattern);

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);

        ResponseEntity<BaseResultDTO<List<BaseItemDto>>> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<BaseItemDto>>>() {
        }, param);
        return responseEntity.getBody().getResponseWithException("");
    }

 //   @Override
    public List<TmAppDTO> getAppInfoByCodeAndType(String type, List<String> codeList) {

        String url = envProperties.getKnowledgeGraphUri() +  "/restful/service/knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("codes", codeList);
        HttpEntity<?> httpEntity = new HttpEntity<>(params,headers);
        ResponseEntity<BaseResultDTO<List<TmAppDTO>>> respEntity = null;
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<List<TmAppDTO>>>() {
            });
        }
        catch (Exception e){
            log.error("execute km [knowledgegraph/task/applicationRelation] fail, error = {}", e.getMessage());
        }

        if (null != respEntity && null != respEntity.getBody()){
            return  respEntity.getBody().getResponseWithException("");
        }
        return null;
    }


    @Override
    public ActionInfo getActionInfo(String tenantId, String actionId) {
        Map<String, Object> parameter = new HashMap<>();
        parameter.put("actionId", actionId);
        HttpHeaders headers = new HttpHeaders();
        String url=envProperties.getKnowledgeGraphUri()+"/restful/service/knowledgegraph/Action/queryExecutionInfo";
        HttpEntity httpEntity = new HttpEntity<Map>(parameter,headers);
        try {
            ResponseEntity<BaseResultDTO<ActionInfo>> actionResult = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<ActionInfo>>() {
            });
            return actionResult.getBody().getResponseWithException("");

        }catch (Exception ex){
            //吃掉异常
            log.error("body: {}, error: ", JsonUtils.objectToString(parameter), ex);
            return null;
        }
    }

    @Override
    public Object queryVariable(String value, SubmitExecuteContext context) {
        return queryVariable(context.getAuthoredUser().getTenantId(), context.getLocale(), value);
    }

    @Override
    public Object queryVariable(String tenantId, String locale, String value) {
        String url = envProperties.getKnowledgeGraphUri() + "/restful/service/knowledgegraph/mechanism/variable?variableName=" + value + "&tenantId=" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        //headers.add("token",context.getAuthoredUser().getToken());
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        try {
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(url, HttpMethod.GET, requestEntity, BaseResultDTO.class);
            if (!ObjectUtils.isEmpty(responseEntity.getBody())) {
                BaseResultDTO<Map> body = responseEntity.getBody();
                return body.getResponse().get(value);
            }
            return null;
        } catch (Exception e) {
            //吃掉异常
            log.error("url: {}, error: ", url, e);
            return null;
        }
    }
}
