/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.domain;

import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class QueryResultSet {
    private List<QueryResult> queryResults;
    private QueryResult mainQueryResult;

    public List<QueryResult> getQueryResults() {
        return this.queryResults;
    }

    public void setMainQueryResult(QueryResult mainQueryResult) {
        this.mainQueryResult = mainQueryResult;
    }

    public QueryResult getMainQueryResult() {
        if (this.mainQueryResult == null && !this.queryResults.isEmpty()) {
            this.mainQueryResult = this.queryResults.get(0);
        }
        return this.mainQueryResult;
    }

    private QueryResultSet() {
    }

    public static QueryResultSet empty() {
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.queryResults = new ArrayList<QueryResult>();
        queryResultSet.mainQueryResult = QueryResult.empty();
        return queryResultSet;
    }

    public static QueryResultSet withData(String mainDatasource, List<QueryResult> queryResultList) {
        if (queryResultList == null) {
            throw new IllegalArgumentException("queryResultList");
        }
        QueryResultSet queryResultSet = new QueryResultSet();
        queryResultSet.queryResults = queryResultList;
        if (StringUtils.hasText((String)mainDatasource)) {
            for (QueryResult queryResult : queryResultList) {
                if (!mainDatasource.equals(queryResult.getDataSourceName())) continue;
                queryResultSet.mainQueryResult = queryResult;
                break;
            }
        } else {
            queryResultSet.mainQueryResult = !queryResultList.isEmpty() ? queryResultList.get(0) : QueryResult.empty();
        }
        return queryResultSet;
    }

    public QueryResultSet appendData(QueryResult queryResult) {
        if (queryResult == null) {
            throw new IllegalArgumentException("queryResult");
        }
        this.queryResults.add(queryResult);
        return this;
    }

    public boolean contains(String name) {
        return this.queryResults.stream().anyMatch(queryResult -> name.equals(queryResult.getDataSourceName()));
    }

    @JsonIgnore
    public QueryResult get(String name) {
        Optional<QueryResult> optionalQueryResult = this.queryResults.stream().filter(queryResult -> name.equals(queryResult.getDataSourceName())).findFirst();
        if (optionalQueryResult.isPresent()) {
            return optionalQueryResult.get();
        }
        return null;
    }

    @JsonIgnore
    public Map<String, Object> getPageData() {
        HashMap<String, Object> pageData = new HashMap<String, Object>();
        for (QueryResult queryResult : this.queryResults) {
            if (queryResult.isSingle() && CollectionUtils.isNotEmpty(queryResult.getData())) {
                pageData.put(queryResult.getDataSourceName(), queryResult.getData().get(0));
                continue;
            }
            pageData.put(queryResult.getDataSourceName(), queryResult.getData());
        }
        return pageData;
    }

    @JsonIgnore
    public Map<String, Map<String, Integer>> getPageDataIndex() {
        HashMap<String, Map<String, Integer>> pageData = new HashMap<String, Map<String, Integer>>();
        for (QueryResult queryResult : this.queryResults) {
            pageData.put(queryResult.getDataSourceName(), queryResult.getDataKeyIndex());
        }
        return pageData;
    }

    public Map<String, List<String>> getPageDataKeys() {
        HashMap<String, List<String>> pageDataKeys = new HashMap<String, List<String>>();
        for (QueryResult queryResult : this.queryResults) {
            pageDataKeys.put(queryResult.getDataSourceName(), queryResult.getDataKeys());
        }
        return pageDataKeys;
    }
}

