/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.mongodb;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.mongodb.CommonMongodbService;
import com.digiwin.athena.atdm.mongodb.DistributeLocker;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.buf.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommonMongodbServiceImpl
implements CommonMongodbService {
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String LOCK_NAME_SUFFIX = ":createMongoCollection:lock";
    private static final String LOCK_NAME_PREFIX = "atdm:";
    private List<String> existCollectionList = new ArrayList<String>();

    @Override
    public void createCollectionLock(MongoTemplate mongoTemplate, String collectionName, Map<String, Object> indexMap) {
        if (this.existCollectionList.contains(collectionName)) {
            return;
        }
        if (mongoTemplate.collectionExists(collectionName)) {
            this.existCollectionList.add(collectionName);
            return;
        }
        String tmpLockName = LOCK_NAME_PREFIX + collectionName + LOCK_NAME_SUFFIX;
        DistributeLocker.tryLock30s(this.redisTemplate, tmpLockName, () -> this.createCollectionAndIndex(mongoTemplate, collectionName, indexMap));
    }

    private void createCollectionAndIndex(MongoTemplate mongoTemplate, String collectionName, Map<String, Object> indexMap) {
        mongoTemplate.createCollection(collectionName);
        this.existCollectionList.add(collectionName);
        if (indexMap != null && indexMap.size() > 0) {
            String indexName = StringUtils.join(indexMap.keySet(), (char)'_');
            IndexOptions indexOptions = new IndexOptions();
            indexOptions.background(true);
            indexOptions.name(indexName);
            mongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(indexMap), indexOptions);
        }
    }

    @Override
    public void insert(MongoTemplate mongoTemplate, Map data, String collectionName) {
        mongoTemplate.insert((Object)data, collectionName);
    }

    @Override
    public void updateFirst(MongoTemplate mongoTemplate, String collectionName, Query query, Update update) {
        mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
    }

    @Override
    public List<Map> query(MongoTemplate mongoTemplate, String collectionName, Query query) {
        return mongoTemplate.find(query, Map.class, collectionName);
    }

    public List<Map> executeQueryCommand(MongoTemplate mongoTemplate, String jsonCommand) {
        Document document = mongoTemplate.executeCommand(jsonCommand);
        Map cursor = (Map)document.get("cursor");
        List mapList = (List)cursor.get("firstBatch");
        return mapList;
    }

    public List<Map> executeQueryCommand(MongoTemplate mongoTemplate, Map jsonCommand) {
        return this.executeQueryCommand(mongoTemplate, JsonUtils.objectToString((Object)jsonCommand));
    }

    public void deleteIdexFromCollections(MongoTemplate mongoTemplate, String deleteIndex) {
        Set collectionNameSet = mongoTemplate.getCollectionNames();
        if (CollectionUtils.isEmpty((Collection)collectionNameSet)) {
            return;
        }
        for (String collectionName : collectionNameSet) {
            List indexList = mongoTemplate.indexOps(collectionName).getIndexInfo();
            ArrayList<String> indexNameList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)indexList)) {
                for (IndexInfo indexInfo : indexList) {
                    indexNameList.add(indexInfo.getName());
                }
            }
            if (!indexNameList.contains(deleteIndex)) continue;
            mongoTemplate.indexOps(collectionName).dropIndex(deleteIndex);
        }
    }

    public void insertIndex(MongoTemplate mongoTemplate, Map<String, Object> indexMap) {
        Set collectionNameSet = mongoTemplate.getCollectionNames();
        if (CollectionUtils.isEmpty((Collection)collectionNameSet)) {
            return;
        }
        for (String collectionName : collectionNameSet) {
            if (indexMap == null || indexMap.size() <= 0) continue;
            String indexName = StringUtils.join(indexMap.keySet(), (char)'_');
            IndexOptions indexOptions = new IndexOptions();
            indexOptions.background(true);
            indexOptions.name(indexName);
            List indexList = mongoTemplate.indexOps(collectionName).getIndexInfo();
            ArrayList<String> indexNameList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)indexList)) {
                for (IndexInfo indexInfo : indexList) {
                    indexNameList.add(indexInfo.getName());
                }
            }
            if (!CollectionUtils.isEmpty(indexNameList) && indexNameList.contains(indexName)) continue;
            mongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(indexMap), indexOptions);
        }
    }

    public void updateMulti(MongoTemplate mongoTemplate, String collectionName, Query query, Update update) {
        mongoTemplate.updateMulti(query, (UpdateDefinition)update, collectionName);
    }
}

