/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.domain;

import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.collections.CollectionUtils;

public class ApiMetadata
implements Serializable {
    private String actionId;
    private String invokeType;
    private String serviceName;
    private List<MetadataField> requestFields;
    private List<MetadataField> responseFields = new ArrayList<MetadataField>();
    private Set<String> apiTags;

    public ApiMetadata() {
        this.requestFields = new ArrayList<MetadataField>();
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<MetadataField> getRequestFields() {
        return this.requestFields;
    }

    public void addRequestFields(List<MetadataField> requestFields) {
        this.requestFields.addAll(requestFields);
    }

    public List<MetadataField> getResponseFields() {
        return this.responseFields;
    }

    public void addResponseFields(List<MetadataField> fields) {
        this.addResponseFieldsConsumer(fields, (e, field) -> {
            this.responseFields.get(0).getSubFields().remove(e);
            this.responseFields.get(0).getSubFields().add((MetadataField)field);
        });
    }

    private void addResponseFieldsConsumer(List<MetadataField> fields, BiConsumer<MetadataField, MetadataField> consumer) {
        if (this.responseFields == null) {
            this.responseFields = new ArrayList<MetadataField>();
        }
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        if (this.responseFields.isEmpty()) {
            this.responseFields.addAll(fields);
        } else {
            if (this.responseFields.get(0).getSubFields() == null) {
                this.responseFields.get(0).setSubFields(new ArrayList<MetadataField>());
            }
            HashSet<String> allFields = new HashSet<String>();
            for (MetadataField subField : this.responseFields.get(0).getSubFields()) {
                allFields.add(subField.getName());
            }
            for (MetadataField field : fields) {
                if (!allFields.contains(field.getName())) {
                    this.responseFields.get(0).getSubFields().add(field);
                    continue;
                }
                Optional<MetadataField> existFieldOptional = this.responseFields.get(0).getSubFields().stream().filter(x -> Objects.equals(x.getName(), field.getName())).findFirst();
                existFieldOptional.ifPresent(metadataField -> consumer.accept((MetadataField)metadataField, field));
            }
        }
    }

    public void addVirtuallyResponseFields(List<MetadataField> fields) {
        this.addResponseFieldsConsumer(fields, (e, f) -> {
            List<MetadataField> subFields = e.getSubFields();
            List<MetadataField> sourceSubFields = f.getSubFields();
            if (CollectionUtils.isEmpty(subFields) || CollectionUtils.isEmpty(sourceSubFields)) {
                this.responseFields.get(0).getSubFields().remove(e);
                this.responseFields.get(0).getSubFields().add((MetadataField)f);
            } else if (CollectionUtils.isNotEmpty(sourceSubFields)) {
                this.mergeMetadataField(sourceSubFields, subFields);
            }
        });
    }

    private void mergeMetadataField(List<MetadataField> sourceFields, List<MetadataField> targetFields) {
        Iterator<MetadataField> iterator = sourceFields.iterator();
        while (iterator.hasNext()) {
            MetadataField next = iterator.next();
            String name = next.getName();
            List<MetadataField> subFields = next.getSubFields();
            int index = -1;
            for (int i = 0; i < targetFields.size(); ++i) {
                MetadataField metadataField = targetFields.get(i);
                if (!Objects.equals(metadataField.getName(), name)) continue;
                index = i;
            }
            if (index <= -1) continue;
            MetadataField metadataField = targetFields.get(index);
            List<MetadataField> subTargetFields = metadataField.getSubFields();
            if (CollectionUtils.isNotEmpty(subTargetFields)) {
                iterator.remove();
                if (!CollectionUtils.isNotEmpty(subFields)) continue;
                this.mergeMetadataField(subFields, subTargetFields);
                continue;
            }
            targetFields.remove(index);
        }
        if (CollectionUtils.isNotEmpty(sourceFields)) {
            targetFields.addAll(sourceFields);
        }
    }

    public Set<String> getApiTags() {
        return this.apiTags;
    }

    public void setApiTags(Set<String> apiTags) {
        this.apiTags = apiTags;
    }

    public String getInvokeType() {
        return this.invokeType;
    }

    public void setInvokeType(String invokeType) {
        this.invokeType = invokeType;
    }
}

