/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.terminateData;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.iam.CommonUserService;
import com.digiwin.athena.atdm.terminateData.CommonTerminateDataService;
import com.digiwin.athena.atdm.terminateData.TerminateDataConverter;
import com.digiwin.athena.atdm.terminateData.dto.TerminateDataDTO;
import com.digiwin.athena.atdm.terminateData.po.TerminateDataDO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CommonTerminateDataServiceImpl
implements CommonTerminateDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonTerminateDataServiceImpl.class);
    @Autowired(required=false)
    @Qualifier(value="terminateDataMongoTemplate")
    private MongoTemplate terminateDataMongoTemplate;
    @Autowired
    private CommonAtmcService atmcService;
    @Autowired
    private CommonUserService commonUserService;
    @Autowired
    private TerminateDataConverter terminateDataConverter;
    @Autowired
    private MessageUtils messageUtils;

    private MongoTemplate getTerminateDataMongoTemplate() {
        if (null != this.terminateDataMongoTemplate) {
            return this.terminateDataMongoTemplate;
        }
        throw BusinessException.create((String)"\u521b\u5efaterminateDataMongoTemplate\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e~");
    }

    @Override
    public void saveTerminateData(AuthoredUser authoredUser, TerminateDataDTO terminateDataDTO) {
        if (CollectionUtils.isEmpty(terminateDataDTO.getPageData())) {
            return;
        }
        TerminateDataDO terminateDataDO = this.initTerminateDataDO(authoredUser, terminateDataDTO);
        if (null != terminateDataDO) {
            this.getTerminateDataMongoTemplate().insert((Object)terminateDataDO, authoredUser.getTenantId());
        }
    }

    private TerminateDataDO initTerminateDataDO(AuthoredUser authoredUser, TerminateDataDTO terminateDataDTO) {
        if (CollectionUtils.isEmpty(terminateDataDTO.getPageData())) {
            return null;
        }
        TerminateDataDO terminateDataDO = this.terminateDataConverter.convert(terminateDataDTO);
        terminateDataDO.setUserId(authoredUser.getUserId());
        terminateDataDO.setUserName(authoredUser.getUserName());
        terminateDataDO.setTenantId(authoredUser.getTenantId());
        if (null == terminateDataDO.getTerminateTime()) {
            terminateDataDO.setTerminateTime(LocalDateTime.now());
        }
        return terminateDataDO;
    }

    @Override
    public void saveTerminateData(AuthoredUser authoredUser, List<TerminateDataDTO> dataDTOList) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)dataDTOList.size());
        for (TerminateDataDTO terminateDataDTO : dataDTOList) {
            TerminateDataDO terminateDataDO = this.initTerminateDataDO(authoredUser, terminateDataDTO);
            if (terminateDataDO == null) continue;
            resultList.add(terminateDataDO);
        }
        if (!resultList.isEmpty()) {
            this.getTerminateDataMongoTemplate().insert((Collection)resultList, authoredUser.getTenantId());
        }
    }

    @Override
    public List queryTerminateDataList(String token, String tenantId, String userId, String activityCode, Collection<String> activityIds) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("activityCode").is((Object)activityCode).and("activityId").in(activityIds);
        Query query = Query.query((CriteriaDefinition)criteria);
        List terminateDataList = this.getTerminateDataMongoTemplate().find(query, TerminateDataDO.class, tenantId);
        ArrayList resultList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)terminateDataList)) {
            List<String> needParseNameActivityIds = terminateDataList.stream().filter(terminateDataDO -> StringUtils.isBlank((String)terminateDataDO.getActivityName())).filter(terminateDataDO -> StringUtils.isNotBlank((String)terminateDataDO.getActivityId())).map(TerminateDataDO::getActivityId).collect(Collectors.toList());
            List<String> needParseNameBacklogIds = terminateDataList.stream().filter(terminateDataDO -> StringUtils.isBlank((String)terminateDataDO.getActivityName())).filter(terminateDataDO -> StringUtils.isNotBlank((String)terminateDataDO.getInitiateActivityId())).map(TerminateDataDO::getInitiateActivityId).collect(Collectors.toList());
            Map<String, String> activityIdNameMap = this.queryActivityNameById(needParseNameActivityIds, needParseNameBacklogIds);
            boolean isExternalUser = this.isExternalUser(token, userId);
            String operationType = this.messageUtils.getMessage("shelved_uibot__operation_type_terminate");
            for (TerminateDataDO terminateDataDO2 : terminateDataList) {
                resultList.addAll(this.buildTerminatePageData(operationType, isExternalUser, terminateDataDO2, activityIdNameMap));
            }
        }
        return resultList;
    }

    private boolean isExternalUser(String token, String userId) {
        try {
            Integer userType = this.commonUserService.queryUserType(userId, token);
            return null != userType ? 1 == userType : false;
        }
        catch (Exception ex) {
            log.error("\u8bf7\u6c42IAM\u5224\u65ad\u7528\u6237\u7c7b\u578b\u53d1\u751f\u5f02\u5e38\uff0c\u53c2\u6570\uff1atoken\uff1a{}, userId\uff1a{}, \u5f02\u5e38\u5185\u5bb9\uff1a{}", new Object[]{token, userId, ex.getMessage()});
            return true;
        }
    }

    private Map<String, String> queryActivityNameById(List<String> workItemIdList, List<String> backlogIdList) {
        if (CollectionUtils.isEmpty(workItemIdList)) {
            return Collections.emptyMap();
        }
        return this.atmcService.queryActivityNameById(workItemIdList, backlogIdList);
    }

    private List buildTerminatePageData(String operationType, boolean isExternalUser, TerminateDataDO terminateDataDO, Map<String, String> activityIdNameMap) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String terminateDateTimeStr = TimeUtils.format((LocalDateTime)terminateDataDO.getTerminateTime(), (String)"yyyy/MM/dd HH:mm:ss");
        for (Map<String, Object> rowData : terminateDataDO.getPageData()) {
            rowData.put("uibot__userId", terminateDataDO.getUserId());
            rowData.put("uibot__userName", terminateDataDO.getUserName());
            rowData.put("uibot__operationReason", terminateDataDO.getComment());
            rowData.put("uibot__dateTime", terminateDataDO.getTerminateTime());
            rowData.put("uibot__operationType", operationType);
            if (StringUtils.isNotBlank((String)terminateDataDO.getInitiateActivityId())) {
                rowData.put("uibot__initiateActivityId", terminateDataDO.getInitiateActivityId());
                rowData.put("uibot__initiateActivityCode", terminateDataDO.getInitiateActivityCode());
                rowData.put("uibot__initiateActivityName", terminateDataDO.getInitiateActivityName());
                rowData.put("uibot__link", !isExternalUser && !StringUtils.equals((String)terminateDataDO.getActivityId(), (String)terminateDataDO.getInitiateActivityId()));
            } else {
                rowData.put("uibot__initiateActivityId", terminateDataDO.getActivityId());
                rowData.put("uibot__initiateActivityCode", terminateDataDO.getActivityCode());
                String activityName = terminateDataDO.getActivityName();
                activityName = StringUtils.isNotBlank((String)activityName) ? activityName : (StringUtils.isNotBlank((String)activityIdNameMap.get(terminateDataDO.getActivityId())) ? activityIdNameMap.get(terminateDataDO.getActivityId()) : activityIdNameMap.get(terminateDataDO.getInitiateActivityId()));
                rowData.put("uibot__initiateActivityName", activityName);
                rowData.put("uibot__link", false);
            }
            rowData.remove("uibot_checked");
            if (null != rowData.get("__DATA_KEY")) {
                String dataKey = rowData.get("__DATA_KEY").toString();
                String initiateActivityCodeStr = null != rowData.get("uibot__initiateActivityCode") ? rowData.get("uibot__initiateActivityCode").toString() : "NAN";
                String newDataKey = operationType + ";" + terminateDataDO.getUserId() + ";" + terminateDateTimeStr + ";" + initiateActivityCodeStr + ";" + dataKey;
                rowData.put("__DATA_KEY", newDataKey);
            }
            resultList.add(rowData);
        }
        return resultList;
    }
}

