package com.digiwin.athena.atdm.ptm;

import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawCrossBkReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawRespDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import com.digiwin.athena.atdm.datasource.domain.Action;

import java.util.List;

public interface CommonPtmService {

    /**
     * 以post方式执行action
     *
     * @param action
     */
    void execute(Action action);

    /**
     * 查询撤回当前任务时 所需要关联撤回的所有任务（包括当前任务）
     *
     * @param retrieveReqDTO
     * @return
     */
    List<PtmWithdrawRespDTO> queryRelativeWithdrawTask(PtmWithdrawReqDTO retrieveReqDTO);

    /**
     * 执行撤回
     *
     * @param retrieveReqDTO
     */
    void executeRelativeTaskWithdraw(PtmWithdrawReqDTO retrieveReqDTO);

    /**
     * 执行跨BK撤回
     *
     * @param retrieveReqDTOList
     */
    List<PtmWorkItemDTO> executeRelativeTaskWithdrawCrossBk(List<PtmWithdrawCrossBkReqDTO> retrieveReqDTOList,String serviceUri);
}
