package com.digiwin.athena.atdm.ptm;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.constant.LogConstant;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDataDto;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawCrossBkReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawCrossBkRespDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawRespDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class CommonPtmServiceImpl implements CommonPtmService {

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private MessageUtils messageUtils;

    /**
     * 以post方式执行action
     *
     * @param action
     */
    @Override
    public void execute(Action action) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;

        if (StringUtils.hasText(serviceId.getProxyToken())) {
            headerMap.add(GlobalConstant.IAM_USER_TOKEN, serviceId.getProxyToken());
            headerMap.add(GlobalConstant.IAM_IDENTITY_TYPE_TOKEN, serviceId.getProxyToken());
        }
        String serviceUri = envProperties.getPtmUri() + serviceId.getServiceUri();
        String tenantId = serviceId.getTenant_id();
//        log.info("[执行PTM]，uri：{}，header：{}, body：{}", serviceUri, JsonUtils.objectToString(headerMap), JsonUtils.objectToString(action.getParas()));
        LogDto logDto = new LogDto("执行ptm action开始，serviceUri：" + serviceUri, tenantId + LogConstant.TRACE_SEPARATOR + serviceUri);

        LogDataDto logDataDto = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
        logDto.setData(Arrays.asList(logDataDto));
        log.info(logDto.toString());

        try {
            HttpEntity httpEntity = new HttpEntity<Map>(action.getParas(), headerMap);
            ResponseEntity<BaseResultDTO> responseEntity = restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO>() {
            });
            responseEntity.getBody().getResponseWithException("");
            LogDto logDtoSuccess = new LogDto("执行ptm action成功，serviceUri：" + serviceUri, tenantId + LogConstant.TRACE_SEPARATOR + serviceUri);
            LogDataDto logDataDtoSuccess = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
            logDtoSuccess.setData(Arrays.asList(logDataDtoSuccess));
            log.info(logDtoSuccess.toString());
//            if (responseEntity.getBody() != null) {
//                Map result = responseEntity.getBody();
//                if (!"200".equals(result.get("status").toString())) {
//                    throw BusinessException.create(String.format(messageUtils.getMessage("exception.execution.ptm.api.fail"), result.get("errorMessage"), serviceUri, action.getParas()));
//                }
//            }

        } catch (Exception ex) {
            LogDto logDtoFail = new LogDto("执行ptm action失败，serviceUri：" + serviceUri, tenantId + LogConstant.TRACE_SEPARATOR + serviceUri);
            LogDataDto logDataDtoFail = new LogDataDto(serviceId.getServiceUri(), "调用url", LogConstant.TYPE_LINK, LogConstant.LABEL_TASK_ENGINE);
            logDtoFail.setData(Arrays.asList(logDataDtoFail));
            log.error(logDtoFail.toString());
            log.error("body: {}, error: ", JsonUtils.objectToString(action.getParas()), ex);
            throw ex;

//            throw BusinessException.create(String.format(messageUtils.getMessage("exception.execution.ptm.api.fail2"), serviceUri, action.getParas(), ex.getMessage()));
        }
    }

    @Override
    public List<PtmWithdrawRespDTO> queryRelativeWithdrawTask(PtmWithdrawReqDTO retrieveReqDTO) {
        String url = envProperties.getPtmUri() + "api/task/card/bk/info";
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<?> httpEntity = new HttpEntity<>(retrieveReqDTO, headers);
        try {
            ResponseEntity<BaseResultDTO<List<PtmWithdrawRespDTO>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<PtmWithdrawRespDTO>>>() {
                    });
            return respEntity.getBody().getResponseWithException("");
//            if (null != respEntity.getBody() && HttpStatus.OK.value() == respEntity.getStatusCodeValue()
//                    && respEntity.getBody().isOK()) {
//                return respEntity.getBody().getResponse();
//            } else {
//                log.error("[ptm-task-withdraw-{}] atmc访问PTM查询需关联撤回的任务出现异常 data: {}, 响应内容: {}", retrieveReqDTO.getBacklogId(), JsonUtils.objectToString(retrieveReqDTO), respEntity.getBody());
//
//                String message = messageUtils.getMessage("exception.task.withdraw.query.relative.task.failed");
//                BusinessException ex = BusinessException.create(respEntity.getStatusCodeValue(), message);
//                ex.setErrorMessage(JsonUtils.objectToString(respEntity.getBody()));
//                ex.setStatusDescription(respEntity.getStatusCode().getReasonPhrase());
//                throw ex;
//            }
        } catch (Exception ex) {
            log.error("[ptm-task-withdraw-{}] body: {}, error: ", JsonUtils.objectToString(retrieveReqDTO), ex);
            throw ex;

//            String message = messageUtils.getMessage("exception.task.withdraw.query.relative.task.failed");
//            throw BusinessException.create(599, "599", message, ex.getMessage(), messageUtils.getMessage("exception.accessing.external.API"), ex);
        }
    }

    @Override
    public void executeRelativeTaskWithdraw(PtmWithdrawReqDTO retrieveReqDTO) {
        String url = envProperties.getPtmUri() + "api/task/card/taskWithdraw";
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<?> httpEntity = new HttpEntity<>(retrieveReqDTO, headers);
        try {
            ResponseEntity<BaseResultDTO> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO>() {
                    });
            respEntity.getBody().getResponseWithException("");
//            if (null != respEntity.getBody() && HttpStatus.OK.value() == respEntity.getStatusCodeValue()
//                     && respEntity.getBody().isOK()) {
//                return;
//            } else {
//                log.error("[ptm-task-withdraw-{}] atmc访问PTM执行任务撤回操作出现异常, data: {}, 响应内容: {}", retrieveReqDTO.getBacklogId(), JsonUtils.objectToString(retrieveReqDTO), respEntity.getBody());
//
//                String message = messageUtils.getMessage("exception.task.withdraw.execute.failed");
//                BusinessException ex = BusinessException.create(respEntity.getStatusCodeValue(), message);
//                ex.setErrorMessage(JsonUtils.objectToString(respEntity.getBody()));
//                ex.setStatusDescription(respEntity.getStatusCode().getReasonPhrase());
//                throw ex;
//            }
        } catch (Exception ex) {
            log.error("[ptm-task-withdraw-{}] body: {}, error: ", JsonUtils.objectToString(retrieveReqDTO), ex);
            throw ex;

//            String message = messageUtils.getMessage("exception.task.withdraw.execute.failed");
//            throw BusinessException.create(599, "599", message, ex.getMessage(), messageUtils.getMessage("exception.accessing.external.API"), ex);
        }
    }

    @Override
    public List<PtmWorkItemDTO> executeRelativeTaskWithdrawCrossBk(List<PtmWithdrawCrossBkReqDTO> retrieveReqDTOList, String serviceUri) {
        String url = envProperties.getPtmUri() + serviceUri;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map paramMap = new HashMap();
        paramMap.put("params", retrieveReqDTOList);

        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
        try {
            ResponseEntity<BaseResultDTO<PtmWithdrawCrossBkRespDTO>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<PtmWithdrawCrossBkRespDTO>>() {
                    });
            return respEntity.getBody().getResponseWithException("").getWorkitemList();
        } catch (Exception ex) {
            log.error("[ptm-task-crossbk-withdraw-{}] body: {}, error: ", JsonUtils.objectToString(retrieveReqDTOList), ex);
            throw ex;
        }
    }
}
