/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.dataUniformity;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.dataUniformity.DataUniformityMongodbService;
import com.digiwin.athena.atdm.dataUniformity.DataUniformitySubmitDO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class DataUniformityMongodbServiceImpl
implements DataUniformityMongodbService {
    @Autowired(required=false)
    @Qualifier(value="dataUniformityMongoTemplate")
    private MongoTemplate dataUniformityMongoTemplate;

    private MongoTemplate getDataUniformityMongoTemplate() {
        if (null != this.dataUniformityMongoTemplate) {
            return this.dataUniformityMongoTemplate;
        }
        throw BusinessException.create((String)"\u521b\u5efadataUniformityMongoTemplate\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e~");
    }

    @Override
    public List<Map> selectTransactionData(String collection, List<String> cardId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(cardId).and("optType").ne(null).ne((Object)"").and("dealType").ne((Object)"end"));
        query.fields().include("bk").include("cardId").exclude("_id");
        return this.getDataUniformityMongoTemplate().find(query, Map.class, collection);
    }

    @Override
    public void updateDealType(String collection, List<Map<String, Object>> updataDataList) {
        for (Map<String, Object> dataMap : updataDataList) {
            TreeMap treeMap = (TreeMap)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataMap.get("bk")), TreeMap.class);
            Long workitemId = Long.valueOf(dataMap.get("workitemId").toString());
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"bk").is((Object)treeMap).and("cardId").is((Object)workitemId));
            Update update = new Update();
            update.set("dealType", dataMap.get("dealType"));
            update.set("modifyDate", (Object)LocalDateTime.now());
            this.getDataUniformityMongoTemplate().updateFirst(query, (UpdateDefinition)update, collection);
        }
    }

    @Override
    public List<Map> getBkByCardId(String collection, List<Long> cardIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(cardIds));
        return this.getDataUniformityMongoTemplate().find(query, Map.class, collection);
    }

    @Override
    public void updateCompleted(String collection, List<Map<String, Object>> updataDataList) {
        for (Map<String, Object> dataMap : updataDataList) {
            TreeMap treeMap = (TreeMap)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataMap.get("bk")), TreeMap.class);
            Long workitemId = Long.valueOf(dataMap.get("workitemId").toString());
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"bk").is((Object)treeMap).and("cardId").is((Object)workitemId));
            Update update = new Update();
            update.set("completed", (Object)true);
            update.set("modifyDate", (Object)LocalDateTime.now());
            this.getDataUniformityMongoTemplate().updateFirst(query, (UpdateDefinition)update, collection);
        }
    }

    @Override
    public void recordSubmittedData(String collection, Long backlogId, Map<String, Object> submitData) {
        DataUniformitySubmitDO dataUniformitySubmitDO = new DataUniformitySubmitDO();
        dataUniformitySubmitDO.setCardId(backlogId);
        dataUniformitySubmitDO.setData(submitData);
        dataUniformitySubmitDO.setSubmitTime(LocalDateTime.now());
        this.getDataUniformityMongoTemplate().insert((Object)dataUniformitySubmitDO, collection);
    }
}

