/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.thememap;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.annocache.Cache;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.thememap.dto.MetadataDataDTO;
import com.digiwin.athena.atdm.thememap.dto.MetadataFieldDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonMetadataServiceImpl
implements CommonMetadataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonMetadataServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;
    private static String patternStr = "^\\((?<length>\\d*?),(?<place>\\d*?)\\)$|^(?<size>\\d*?)$";
    private static Pattern pattern = Pattern.compile(patternStr);
    static String METADATA_URL = "/restful/service/knowledgegraph/Action/Metadata";

    @Override
    @Cache(key="'uibot:cache:'+ctx_auth.authoredUser.tenantId+':'+'km_getMetadata_'+locale+actionId")
    public ApiMetadata getMetadata(String locale, String actionId) {
        if (!StringUtils.hasText((String)actionId)) {
            return null;
        }
        String url = this.envProperties.getKnowledgeGraphUri() + METADATA_URL + "?actionId=" + actionId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<MetadataDataDTO>>(){}, new Object[0]);
            return CommonMetadataServiceImpl.createApiMetadata((MetadataDataDTO)((BaseResultDTO)response.getBody()).getResponseWithException(this.messageUtils.getMessage("exception.find.data.from.KG")));
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    public static ApiMetadata createApiMetadata(MetadataDataDTO metadataDataDTO) {
        ApiMetadata apiMetadata = new ApiMetadata();
        String actionId = metadataDataDTO.getActionId();
        String serviceName = metadataDataDTO.getServiceName();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        apiMetadata.setInvokeType(metadataDataDTO.getInvokeType());
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.addRequestFields(CommonMetadataServiceImpl.createMetadataField(new ArrayList<MetadataField>(), metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.addResponseFields(CommonMetadataServiceImpl.createMetadataField(new ArrayList<MetadataField>(), metadataDataDTO.getResponse().getData()));
        }
        return apiMetadata;
    }

    private static List<MetadataField> createMetadataField(List<MetadataField> requestFields, List<MetadataFieldDTO> metadataFieldDTOs) {
        for (MetadataFieldDTO metadataFieldDTO : metadataFieldDTOs) {
            Matcher m;
            MetadataField metadataField = new MetadataField();
            metadataField.setName(metadataFieldDTO.getData_name());
            if (metadataFieldDTO.getRequired() == null) {
                metadataField.setRequired(false);
            } else {
                metadataField.setRequired(metadataFieldDTO.getRequired());
            }
            metadataField.setDescription(metadataFieldDTO.getDescription());
            metadataField.setRemark(metadataFieldDTO.getRemark());
            metadataField.setBusinessKey(metadataFieldDTO.getIs_businesskey());
            metadataField.setDataKey(metadataFieldDTO.getIs_datakey());
            metadataField.setDataType(metadataFieldDTO.getData_type());
            metadataField.setCanSort(metadataFieldDTO.getCan_sort());
            metadataField.setCanFilter(metadataFieldDTO.getCan_filter());
            metadataField.setEnumKey(metadataFieldDTO.getEnum_key());
            if (metadataFieldDTO.getPrecision() != null && (m = pattern.matcher(metadataFieldDTO.getPrecision())).matches()) {
                HashMap<String, Integer> precision = new HashMap<String, Integer>();
                if (m.group("size") != null) {
                    precision.put("length", Integer.parseInt(m.group("size")));
                    metadataField.setPrecision(precision);
                } else if (m.group("length") != null && m.group("place") != null) {
                    precision.put("length", Integer.parseInt(m.group("length")));
                    precision.put("place", Integer.parseInt(m.group("place")));
                    metadataField.setPrecision(precision);
                }
            }
            metadataField.setArray(metadataFieldDTO.getIs_array());
            if (CollectionUtils.isNotEmpty(metadataFieldDTO.getField())) {
                ArrayList<MetadataField> subRequestFields = new ArrayList<MetadataField>();
                metadataField.setSubFields(CommonMetadataServiceImpl.createMetadataField(subRequestFields, metadataFieldDTO.getField()));
            }
            requestFields.add(metadataField);
        }
        return requestFields;
    }

    private static List<MetadataField> createMetadataField(List<MetadataField> requestFields, MetadataFieldDTO metadataFieldDTO) {
        MetadataField metadataField = new MetadataField();
        metadataField.setName(metadataFieldDTO.getData_name());
        if (metadataFieldDTO.getRequired() == null) {
            metadataField.setRequired(false);
        } else {
            metadataField.setRequired(metadataFieldDTO.getRequired());
        }
        metadataField.setDescription(metadataFieldDTO.getDescription());
        metadataField.setRemark(metadataFieldDTO.getRemark());
        metadataField.setDataKey(metadataFieldDTO.getIs_datakey());
        metadataField.setBusinessKey(metadataFieldDTO.getIs_businesskey());
        metadataField.setDataType(metadataFieldDTO.getData_type());
        metadataField.setArray(metadataFieldDTO.getIs_array());
        metadataField.setEnumKey(metadataFieldDTO.getEnum_key());
        metadataField.setCanSort(metadataFieldDTO.getCan_sort());
        metadataField.setCanFilter(metadataFieldDTO.getCan_filter());
        if (CollectionUtils.isNotEmpty(metadataFieldDTO.getField())) {
            ArrayList<MetadataField> subRequestFields = new ArrayList<MetadataField>();
            metadataField.setSubFields(CommonMetadataServiceImpl.createMetadataField(subRequestFields, metadataFieldDTO.getField()));
        }
        requestFields.add(metadataField);
        return requestFields;
    }
}

