package com.digiwin.athena.atdm.activity.domain;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;

import java.util.List;
import java.util.Map;

/**
 * 前端执行的Action实体
 * 例如执行保存、更新、删除等action
 *
 * @author zhujg
 */
public class SubmitActionDTO {

    /**
     * 主ACTION
     */
    private SubmitAction action;

    /**
     * Action的数据
     */
    private Map<String, Object> data;

    /**
     * 最小化拆分每笔item对应的数据
     */
    private Map<Long, Map<String, Object>> workItemIdToData ;

    /**
     * 实际操作的用户
     */
    private AuthoredUser operateAuthoredUser;
    private SubmitAction actionMerge;
    private List<Map<String, Object>> dataMerge;

    public SubmitAction getAction() {
        return action;
    }

    public void setAction(SubmitAction action) {
        this.action = action;
    }

    public Map<String, Object> getData() {
        return data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public AuthoredUser getOperateAuthoredUser() {
        return operateAuthoredUser;
    }

    public void setOperateAuthoredUser(AuthoredUser operateAuthoredUser) {
        this.operateAuthoredUser = operateAuthoredUser;
    }

    public List<Map<String, Object>> getDataMerge() {
        return dataMerge;
    }

    public void setDataMerge(List<Map<String, Object>> dataMerge) {
        this.dataMerge = dataMerge;
    }

    public SubmitAction getActionMerge() {
        return actionMerge;
    }

    public void setActionMerge(SubmitAction actionMerge) {
        this.actionMerge = actionMerge;
    }

    public Map<Long, Map<String, Object>> getWorkItemIdToData() {
        return workItemIdToData;
    }

    public void setWorkItemIdToData(Map<Long, Map<String, Object>> workItemIdToData) {
        this.workItemIdToData = workItemIdToData;
    }
}
