package com.digiwin.athena.atdm.activity.service;

import com.digiwin.athena.atdm.DataSourceConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.activity.DataSourceDTOFactory;
import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description: dataSource 业务逻辑处理层
 * 将TM-ACTION 转换为 uiBot-ACTION
 * @author: wangminga
 * @create: 2020-09-02 16:31
 **/
@Service
public class BaseTmDataSourceService {

    @Autowired
    private BaseActionCreateService queryActionService;

    @Autowired
    private CommonMetadataService commonMetadataService;


    public DataSourceDTO analysis(ExecuteContext executeContext, String dataSourceName, TmQueryAction tmAction, Map bpmData ) {
        if (StringUtils.isEmpty(dataSourceName)){
            dataSourceName = tmAction.getName();
        }
        if (CollectionUtils.isEmpty(tmAction.getDataKeys())){
            ApiMetadata apiMetadata =  commonMetadataService.getMetadata(executeContext.getLocale(),tmAction.getActionId());
            if ( apiMetadata != null && CollectionUtils.isNotEmpty(apiMetadata.getResponseFields()) ) {
                List<String> dataKeys = apiMetadata.getResponseFields().stream()
                        .filter(metadataFieldDTO -> BooleanUtils.isTrue(metadataFieldDTO.getBusinessKey()))
                        .map(MetadataField::getName)
                        .collect(Collectors.toList());
                if (dataKeys.size() > 0) {
                    tmAction.setDataKeys(dataKeys);
                }
            }
        }

        //先把数据源关联的数据处理器拿到
        QueryAction queryAction =null;
        switch (tmAction.getType()){
            case UiBotConstants.ACTION_CATEGORY_ESP:
            case UiBotConstants.ACTION_CATEGORY_TM:
            case UiBotConstants.ACTION_CATEGORY_RAW_DATA:
            case UiBotConstants.ACTION_CATEGORY_SD:{
                queryAction =  queryActionService.createQueryAction(executeContext.getTenantId(),executeContext.getBusinessUnit(),tmAction, bpmData);
                queryAction.setCategory(tmAction.getType());
                return DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, null,true);
            }
            case DataSourceConstants.ACTION_CATEGORY_MIX_MERGE:{
                if (tmAction.getLeft() == null ){
                    throw new IllegalArgumentException("合并数据集的左边是null");
                }
                if ( CollectionUtils.isEmpty( tmAction.getRightList())){
                    throw new IllegalArgumentException("合并数据集的右边是null");
                }
                //把process放到主数据源上
                DataSourceDTO left = analysis(executeContext,"left",tmAction.getLeft(),bpmData);
                List<DataSourceDTO> rightList = new ArrayList<>();
                int index=0;
                for (TmQueryAction tmQueryAction : tmAction.getRightList()) {
                    //待合并的数据源暂时把process去掉
                    DataSourceDTO dataSourceBase = analysis(executeContext,"rigth-" +index,tmQueryAction,bpmData);
                    rightList.add(dataSourceBase);
                    index++;
                }
                DataSourceDTO mergeDataSource=new DataSourceDTO();
                mergeDataSource.setLeft(left);
                mergeDataSource.setType(DataSourceConstants.ACTION_CATEGORY_MIX_MERGE);
                mergeDataSource.setRightList(rightList);
                mergeDataSource.setName(dataSourceName);
                mergeDataSource.setActionId(tmAction.getLeft().getActionId());
                mergeDataSource.setDataKeys( tmAction.getLeft().getDataKeys());
                mergeDataSource.setMetadataFields(tmAction.getMetadataFields());
                return  mergeDataSource;
            }
            case DataSourceConstants.ACTION_CATEGORY_MIX_LEFT_JOIN: {
                if (tmAction.getLeft() == null ){
                    throw new IllegalArgumentException("合并数据集的左边是null");
                }
                if ( CollectionUtils.isEmpty( tmAction.getRightList())){
                    throw new IllegalArgumentException("合并数据集的右边是null");
                }
                //把process放到主数据源上
                DataSourceDTO left = analysis(executeContext,"left",tmAction.getLeft(),bpmData);
                List<DataSourceDTO> rightList = new ArrayList<>();
                int index=0;
                for (TmQueryAction tmQueryAction : tmAction.getRightList()) {
                    //待合并的数据源暂时把process去掉
                    DataSourceDTO dataSourceBase = analysis(executeContext,"rigth-" +index,tmQueryAction,bpmData);
                    rightList.add(dataSourceBase);
                    index++;
                }
                DataSourceDTO leftJoinDataSource=new DataSourceDTO();
                leftJoinDataSource.setType(DataSourceConstants.ACTION_CATEGORY_MIX_LEFT_JOIN);
                leftJoinDataSource.setLeft(left);
                leftJoinDataSource.setRightList(rightList);
                leftJoinDataSource.setName(dataSourceName);
                leftJoinDataSource.setActionId(tmAction.getLeft().getActionId());
                leftJoinDataSource.setDataKeys( tmAction.getLeft().getDataKeys());
                leftJoinDataSource.setMetadataFields(tmAction.getMetadataFields());
                leftJoinDataSource.setOverride(tmAction.getOverride());
                return  leftJoinDataSource;
            }
        }

        return null;
    }


    public DataSourceDTO analysisHasParas(ExecuteContext executeContext, String dataSourceName, TmQueryAction  tmAction, Map paras ) {
        if (StringUtils.isEmpty(dataSourceName)){
            dataSourceName = tmAction.getName();
        }

        //先把数据源关联的数据处理器拿到
        QueryAction  queryAction =null;
        switch (tmAction.getType()){
            case UiBotConstants.ACTION_CATEGORY_ESP:
            case UiBotConstants.ACTION_CATEGORY_TM:
            case UiBotConstants.ACTION_CATEGORY_RAW_DATA:
            case UiBotConstants.ACTION_CATEGORY_SD:{
                queryAction = queryActionService.createQueryHasParasAction(executeContext.getTenantId(),executeContext.getBusinessUnit(),tmAction,paras);
                queryAction.setCategory(tmAction.getType());
                break;
            }
        }
        if (queryAction != null) {
            return DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, null,true);
        }
        return null;
    }

}
