package com.digiwin.athena.atdm.uibot;

import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import com.digiwin.athena.atdm.uibot.dto.UiBotTaskWithdrawReqDTO;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;

import java.util.List;
import java.util.Map;

/**
 * UiBotService Description
 *
 * @author majianfu
 * @date 2022/2/17
 * @since
 */
public interface CommonUiBotService {
    /**
     * 查询终止数据任务定义（终止按钮提交定义、pageData等）
     *
     * @param tmProjectId
     * @param tmActivityId
     * @param workItemId
     * @param bkList
     * @return
     */
    Map queryTerminateDataPageDefine(String tmProjectId, String tmActivityId, Long workItemId, List bkList);

    /**
     * 获取数据一致性异常排除任务卡的定义
     *
     * @Author：SYQ
     * @Date：2022/5/26 15:32
     */
    List<Map> queryDataUniformityPageDefine(String tmProjectId, String tmActivityId, String workItemId);

    /**
     * 获取未完成数据
     *
     * @Author：SYQ
     * @Date：2022/6/7 18:15
     */
    List<Map<String, Object>> getUnfinishedData(String tmProjectId, String tmActivityId, String workItemId);

    Map<String, Object> getAFCData();

    /**
     * 查询撤回任务的定义
     *
     * @param uiBotTaskWithdrawReqList
     * @return <workItemId, pageDefine>
     * @Author majfa
     * @Date 2022/10/13
     */
    Map<Long, List<Map>> queryTaskWithdrawPageDefine(List<UiBotTaskWithdrawReqDTO> uiBotTaskWithdrawReqList);

    /**
     * 查询跨BK撤回任务的定义
     *
     * @param uiBotTaskWithdrawReqList
     * @return <workItemId, pageDefine>
     * @Author lisheng
     * @Date 2024/4/2
     */
    Map<Long, List<Map>> queryTaskCrossBkWithdrawPageDefine(List<PtmWorkItemDTO> uiBotTaskWithdrawReqList);

    /**
     * 获取任务submitAction
     * @param tmTaskId
     * @param tmActivityId
     * @param activityData
     * @return
     */
    List<SubmitAction> getTaskPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData);

}
