package com.digiwin.athena.atdm.adsc.dto;

import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.Data;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * adsc数据查询入口dto
 *
 * @author jianglpc
 * @version 1.0
 * @since 2023/3/3
 */
@Data
public class AdscDataQueryDTO {

    /**
     * 操作内容
     */
    private Action action;

    /**
     * 分页查询参数
     */
    private PageInfo pageInfo;

    /**
     * "sortInfo": [
     * {derType": "asc",
     * "orderType": "asc",hema": "createtime"
     * "schema": "createtime"
     */
    private List<Map> sortInfo;

    /**
     * "searchInfo": [
     * {
     * "searchField": "name",
     * "searchOpt": "in",
     * "searchValues": [
     * "name1",
     * "name2"
     * ]
     * },
     * {
     * "searchField": "status",
     * "searchOpt": "in",
     * "searchValues": [
     * 1
     * ]
     * }
     */
    private List<Map> searchInfo;

    /**
     *
     */
    private String rowSizeType;
    /**
     * 业务参数数据
     */
    private Map<String, Object> parameter;

    /**
     * 执行上下文
     */
    private ExecuteContext executeContext;


    /**
     * 分组 支持 treeTable 的样式
     */
    private JSONObject settings;

    /**
     * condition字段
     */
    private List<String> conditionFeildId;

    /**
     *
     */
    private List<String> conditionFileds;

    /**
     * 数据的状态
     * waiting 待处理
     * tracing 追踪中
     * completed 已完成
     * processing 处理中
     */
    private String dataStateCode;
}
