/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.activity.service;

import com.digiwin.athena.atdm.activity.DataSourceDTOFactory;
import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.activity.service.BaseActionCreateService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BaseTmDataSourceService {
    @Autowired
    private BaseActionCreateService queryActionService;
    @Autowired
    private CommonMetadataService commonMetadataService;

    public DataSourceDTO analysis(ExecuteContext executeContext, String dataSourceName, TmQueryAction tmAction, Map bpmData) {
        List<String> dataKeys;
        ApiMetadata apiMetadata;
        if (StringUtils.isEmpty((Object)dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        if (CollectionUtils.isEmpty(tmAction.getDataKeys()) && (apiMetadata = this.commonMetadataService.getMetadata(executeContext.getLocale(), tmAction.getActionId())) != null && CollectionUtils.isNotEmpty(apiMetadata.getResponseFields()) && (dataKeys = apiMetadata.getResponseFields().stream().filter(metadataFieldDTO -> BooleanUtils.isTrue((Boolean)metadataFieldDTO.getBusinessKey())).map(MetadataField::getName).collect(Collectors.toList())).size() > 0) {
            tmAction.setDataKeys(dataKeys);
        }
        QueryAction queryAction = null;
        switch (tmAction.getType()) {
            case "ESP": 
            case "TM": 
            case "RAWDATA": 
            case "SD": {
                queryAction = this.queryActionService.createQueryAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), tmAction, bpmData);
                queryAction.setCategory(tmAction.getType());
                return DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, null, true);
            }
            case "MIX_MERGE": {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u5de6\u8fb9\u662fnull");
                }
                if (CollectionUtils.isEmpty(tmAction.getRightList())) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u53f3\u8fb9\u662fnull");
                }
                DataSourceDTO left = this.analysis(executeContext, "left", tmAction.getLeft(), bpmData);
                ArrayList<DataSourceDTO> rightList = new ArrayList<DataSourceDTO>();
                int index = 0;
                for (TmQueryAction tmQueryAction : tmAction.getRightList()) {
                    DataSourceDTO dataSourceBase = this.analysis(executeContext, "rigth-" + index, tmQueryAction, bpmData);
                    rightList.add(dataSourceBase);
                    ++index;
                }
                DataSourceDTO mergeDataSource = new DataSourceDTO();
                mergeDataSource.setLeft(left);
                mergeDataSource.setType("MIX_MERGE");
                mergeDataSource.setRightList(rightList);
                mergeDataSource.setName(dataSourceName);
                mergeDataSource.setActionId(tmAction.getLeft().getActionId());
                mergeDataSource.setDataKeys(tmAction.getLeft().getDataKeys());
                mergeDataSource.setMetadataFields(tmAction.getMetadataFields());
                return mergeDataSource;
            }
            case "MIX_LEFT_JOIN": {
                if (tmAction.getLeft() == null) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u5de6\u8fb9\u662fnull");
                }
                if (CollectionUtils.isEmpty(tmAction.getRightList())) {
                    throw new IllegalArgumentException("\u5408\u5e76\u6570\u636e\u96c6\u7684\u53f3\u8fb9\u662fnull");
                }
                DataSourceDTO left = this.analysis(executeContext, "left", tmAction.getLeft(), bpmData);
                ArrayList<DataSourceDTO> rightList = new ArrayList<DataSourceDTO>();
                int index = 0;
                for (TmQueryAction tmQueryAction : tmAction.getRightList()) {
                    DataSourceDTO dataSourceBase = this.analysis(executeContext, "rigth-" + index, tmQueryAction, bpmData);
                    rightList.add(dataSourceBase);
                    ++index;
                }
                DataSourceDTO leftJoinDataSource = new DataSourceDTO();
                leftJoinDataSource.setType("MIX_LEFT_JOIN");
                leftJoinDataSource.setLeft(left);
                leftJoinDataSource.setRightList(rightList);
                leftJoinDataSource.setName(dataSourceName);
                leftJoinDataSource.setActionId(tmAction.getLeft().getActionId());
                leftJoinDataSource.setDataKeys(tmAction.getLeft().getDataKeys());
                leftJoinDataSource.setMetadataFields(tmAction.getMetadataFields());
                leftJoinDataSource.setOverride(tmAction.getOverride());
                return leftJoinDataSource;
            }
        }
        return null;
    }

    public DataSourceDTO analysisHasParas(ExecuteContext executeContext, String dataSourceName, TmQueryAction tmAction, Map paras) {
        if (StringUtils.isEmpty((Object)dataSourceName)) {
            dataSourceName = tmAction.getName();
        }
        QueryAction queryAction = null;
        switch (tmAction.getType()) {
            case "ESP": 
            case "TM": 
            case "RAWDATA": 
            case "SD": {
                queryAction = this.queryActionService.createQueryHasParasAction(executeContext.getTenantId(), executeContext.getBusinessUnit(), tmAction, paras);
                queryAction.setCategory(tmAction.getType());
            }
        }
        if (queryAction != null) {
            return DataSourceDTOFactory.create(tmAction, queryAction, dataSourceName, null, true);
        }
        return null;
    }
}

