/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.ptm;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDataDto;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.ptm.CommonPtmService;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawCrossBkReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawCrossBkRespDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawReqDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWithdrawRespDTO;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonPtmServiceImpl
implements CommonPtmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonPtmServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void execute(Action action) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        ActionServiceId serviceId = action.getServiceId();
        ActionServiceId actionServiceId = serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;
        if (StringUtils.hasText((String)serviceId.getProxyToken())) {
            headerMap.add("digi-middleware-auth-user", serviceId.getProxyToken());
            headerMap.add("token", serviceId.getProxyToken());
        }
        String serviceUri = this.envProperties.getPtmUri() + serviceId.getServiceUri();
        String tenantId = serviceId.getTenant_id();
        LogDto logDto = new LogDto("\u6267\u884cptm action\u5f00\u59cb\uff0cserviceUri\uff1a" + serviceUri, tenantId + ";" + serviceUri);
        LogDataDto logDataDto = new LogDataDto(serviceId.getServiceUri(), "\u8c03\u7528url", "link", "taskEngine");
        logDto.setData(Arrays.asList(logDataDto));
        log.info(logDto.toString());
        try {
            HttpEntity httpEntity = new HttpEntity(action.getParas(), (MultiValueMap)headerMap);
            ResponseEntity responseEntity = this.restTemplate.exchange(serviceUri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
            LogDto logDtoSuccess = new LogDto("\u6267\u884cptm action\u6210\u529f\uff0cserviceUri\uff1a" + serviceUri, tenantId + ";" + serviceUri);
            LogDataDto logDataDtoSuccess = new LogDataDto(serviceId.getServiceUri(), "\u8c03\u7528url", "link", "taskEngine");
            logDtoSuccess.setData(Arrays.asList(logDataDtoSuccess));
            log.info(logDtoSuccess.toString());
        }
        catch (Exception ex) {
            LogDto logDtoFail = new LogDto("\u6267\u884cptm action\u5931\u8d25\uff0cserviceUri\uff1a" + serviceUri, tenantId + ";" + serviceUri);
            LogDataDto logDataDtoFail = new LogDataDto(serviceId.getServiceUri(), "\u8c03\u7528url", "link", "taskEngine");
            logDtoFail.setData(Arrays.asList(logDataDtoFail));
            log.error(logDtoFail.toString());
            log.error("body: {}, error: ", (Object)JsonUtils.objectToString(action.getParas()), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<PtmWithdrawRespDTO> queryRelativeWithdrawTask(PtmWithdrawReqDTO retrieveReqDTO) {
        String url = this.envProperties.getPtmUri() + "api/task/card/bk/info";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)retrieveReqDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<PtmWithdrawRespDTO>>>(){}, new Object[0]);
            return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("[ptm-task-withdraw-{}] body: {}, error: ", (Object)JsonUtils.objectToString((Object)retrieveReqDTO), (Object)ex);
            throw ex;
        }
    }

    @Override
    public void executeRelativeTaskWithdraw(PtmWithdrawReqDTO retrieveReqDTO) {
        String url = this.envProperties.getPtmUri() + "api/task/card/taskWithdraw";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)retrieveReqDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
            ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        }
        catch (Exception ex) {
            log.error("[ptm-task-withdraw-{}] body: {}, error: ", (Object)JsonUtils.objectToString((Object)retrieveReqDTO), (Object)ex);
            throw ex;
        }
    }

    @Override
    public List<PtmWorkItemDTO> executeRelativeTaskWithdrawCrossBk(List<PtmWithdrawCrossBkReqDTO> retrieveReqDTOList, String serviceUri) {
        String url = this.envProperties.getPtmUri() + serviceUri;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<PtmWithdrawCrossBkReqDTO>> paramMap = new HashMap<String, List<PtmWithdrawCrossBkReqDTO>>();
        paramMap.put("params", retrieveReqDTOList);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmWithdrawCrossBkRespDTO>>(){}, new Object[0]);
            return ((PtmWithdrawCrossBkRespDTO)((BaseResultDTO)respEntity.getBody()).getResponseWithException("")).getWorkitemList();
        }
        catch (Exception ex) {
            log.error("[ptm-task-crossbk-withdraw-{}] body: {}, error: ", (Object)JsonUtils.objectToString(retrieveReqDTOList), (Object)ex);
            throw ex;
        }
    }
}

