/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.annocache;

import cn.hutool.extra.expression.ExpressionUtil;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.atdm.annocache.Cache;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="cacheAspect")
@Order(value=100)
public class CacheAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheAspect.class);
    public static final String cachePrefixWord = "uibot:cache:";
    public static final String cachePrefix0 = "'uibot:cache:'+";
    public static final String cachePrefix_tenant = "'uibot:cache:'+ctx_auth.authoredUser.tenantId+':'+";
    public static final String cachePrefix_tenantLang = "'uibot:cache:'+ctx_auth.authoredUser.tenantId+':'+ctx_locale+':'+";
    public static final String cachePrefix_tenantUser = "'uibot:cache:'+ctx_auth.authoredUser.tenantId+':'+ctx_auth.authoredUser.userId+':'+";
    public static final String cachePrefix_tenantUserLang = "'uibot:cache:'+ctx_auth.authoredUser.tenantId+':'+ctx_locale+':'+ctx_auth.authoredUser.userId+':'+";
    @Autowired
    @Qualifier(value="annoRedisTemplate")
    private RedisTemplate redisTemplate;

    @Around(value="@annotation(com.digiwin.athena.atdm.annocache.Cache)")
    public Object processCache(ProceedingJoinPoint jp) throws Throwable {
        if (!Boolean.TRUE.equals(JaProperty.getBoolean((String)"uibot.cache.enable", (Boolean)true))) {
            return jp.proceed();
        }
        Signature sig = jp.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        Method method = msig.getMethod();
        Cache annotation = method.getAnnotation(Cache.class);
        String key = annotation.key();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return jp.proceed();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        Object[] args = jp.getArgs();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String parameterName = parameter.getName();
            Object parameterValue = args[i];
            param.put(parameterName, parameterValue);
        }
        Object keyObj = CacheAspect.evalExpressionWithContext(key, param);
        Object result = this.redisTemplate.opsForValue().get(keyObj);
        if (null != result) {
            return result;
        }
        if (annotation.cacheNull() && this.redisTemplate.hasKey(keyObj).booleanValue()) {
            return result;
        }
        result = jp.proceed();
        if (null != result || annotation.cacheNull()) {
            this.redisTemplate.opsForValue().set(keyObj, result, annotation.ttlSecs(), TimeUnit.SECONDS);
        }
        return result;
    }

    public static Object evalExpressionWithContext(String expression, Map<String, Object> data) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        AppAuthContext ctx = AppAuthContextHolder.getContext();
        root.put("ctx_auth", ctx);
        root.put("ctx_locale", CacheAspect.getLocale());
        if (null != data) {
            root.putAll(data);
        }
        return CacheAspect.evalExpression(expression, root);
    }

    public static Object evalExpression(String expression, Map<String, Object> data) {
        Object obj = ExpressionUtil.eval((String)expression, data);
        return obj;
    }

    public static String getLocale() {
        String locale = LocaleContextHolder.getLocale().toLanguageTag();
        if (StringUtils.isEmpty((CharSequence)locale)) {
            locale = "zh_CN";
        }
        return locale;
    }

    public static void main(String[] args) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("a", 2);
        param.put("b", 2);
        EncryptedConfigDTO dto = new EncryptedConfigDTO();
        dto.setPattern("p1");
        dto.setActivityCode("aaa");
        param.put("dto", dto);
        System.out.println(CacheAspect.evalExpression("'key_'+dto.getPattern()+dto.getActivityCode()", param));
    }
}

