/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.semc;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.semc.FineReportService;
import com.digiwin.athena.atdm.semc.dto.FineReportVO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class FineReportServiceImpl
implements FineReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReportServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    private static final String GET_FINE_REPORT_URL = "/semc/tripartite/fineReport/auth/queryFineReportList";
    private static final ParameterizedTypeReference<BaseResultDTO<FineReportVO>> getFineReportRespType = new ParameterizedTypeReference<BaseResultDTO<FineReportVO>>(){};

    @Override
    public List<FineReportVO.FineReportVOItem> getFineReportList(int deviceType) {
        String url = this.envProperties.getSemcUri() + GET_FINE_REPORT_URL;
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("deviceType", Integer.valueOf(deviceType));
        params.put("displayPermissionFlag", Boolean.valueOf(true));
        BaseResultDTO baseResultDTO = (BaseResultDTO)DwSpringHttpUtil.post((String)url, params, getFineReportRespType);
        FineReportVO fineReportVO = (FineReportVO)baseResultDTO.data();
        if (fineReportVO != null && CollectionUtils.isNotEmpty(fineReportVO.getFineReportList())) {
            List<FineReportVO.FineReportVOItem> fineReportList = fineReportVO.getFineReportList();
            if (fineReportVO.getAllAuthFlag() != null && fineReportVO.getAllAuthFlag() == 0) {
                fineReportList = fineReportVO.getFineReportList().stream().filter(item -> item.getHavePermissionFlag() != null && item.getHavePermissionFlag() != false).collect(Collectors.toList());
            }
            return fineReportList;
        }
        return Collections.emptyList();
    }
}

