package com.digiwin.athena.atdm.activity.domain;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class TmActivity {

    /**
     * 大分类
     */
    private String pattern;

    /**
     * 小分类
     */
    private String category;

    /**
     * 活动ID
     */
   private String activityId;

    /**
     * 活动名称
     */
   private Object activityName;


    /**
     * 数据源定义
     */
   private Map<String, TmQueryAction> dataSources;



    /**
     * 数据API 数据查询条件过滤器
     */
   private List<TmDataFilter> dataFilters;

    /**
     * 数据处理器定义
     */
   private List<TmDataProcess> dataProcessors;

    /**
     * 每个页面固定的属性设置
     */
   private TmPage pages;

    /**
     * 活动定义的全局参数
     * 目前用到的币别
     */
   private Map<String,Object> activityParameter;

    /**
     * 签核任务的发起任务名称
     */
    private String startApproveActivityName;

    /**
     * 签核-可退回的任务ID列表
     */
    private List<String> startApproveActivity;

    /**
     * 签核定义
     */
    private List<TmApproval> approves;


//    private Map<String, TmAction>  abortTaskAction;

    /**
     * 签核-类型：0-核决，1-群组
     */
    private Integer approveType;

    /**
     * 签核-0串接 1并接，目前场景只有串接
     */
    private Integer groupDispatchType;

    /**
     * 附件信息
     */
    private AttachmentConfigInfo attachment;
}
