package com.digiwin.athena.atdm.retrieveData.po;

import lombok.Data;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * RetrieveDataDO Description
 *
 * @author majianfu
 * @date 2022/10/13
 * @since
 */
@Data
@Document(collection = "retrieve_data")
@CompoundIndexes({
        @CompoundIndex(name = "tenant_activity_idx", def = "{'tenantId':1,'activityId':1}"),
        @CompoundIndex(name = "dateTime_idx", def = "{'dateTime':-1}")
})
public class RetrieveDataDO {
    /**
     * 执行终止用户id
     */
    private String userId;

    /**
     * 执行终止用户名称
     */
    private String userName;

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 活动ID，如待办项ID
     */
    private String activityId;

    /**
     * 发起“撤回”的任务backlogId
     */
    private String initiateActivityId;

    /**
     * BK列表
     */
    private List<String> bkList;

    /**
     * BK data列表
     */
    private List<Map<String, Object>> bkDataList;

    /**
     * 终止的数据集
     */
    private List<Map<String, Object>> pageData;

    /**
     * 终止的数据行数
     */
    private Integer pageDataSize;

    /**
     * 终止日期
     */
    private LocalDateTime dateTime;
}
