package com.digiwin.athena.atdm.util;

import cn.hutool.core.map.MapUtil;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.athena.atdm.constant.Variables;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * SearchInfoUtil Description
 *
 * @author majianfu
 * @date 2024/8/9
 * @since
 */
public final class SearchInfoUtil {
    private SearchInfoUtil() {
    }

    /**
     * 合并searchInfo
     * 1、为beginSearchInfos中每个searchInfo添加 "logic": "AND"（若searchInfo设置过逻辑连接符，则跳过）
     * 2、为beginSearchInfos中每个searchInfo添加 "logic"字段（若searchInfo设置过逻辑连接符，则跳过）
     * <p>
     * endSearchInfos中的logic、order字段由前端自己拼接好，其值一般来自于表格的”筛选“功能，无需这边填充.
     *
     * @param beginSearchInfos
     * @param endSearchInfos
     * @return
     */
    @SuppressWarnings({"squid:S1144", "unchecked"})
    public static List<Map> mergeSearchInfo(List<Map> beginSearchInfos, List<Map> endSearchInfos) {//NOSONAR
        List<Map> mergedResults = new ArrayList<>();//NOSONAR
        if (CollectionUtils.isNotEmpty(beginSearchInfos) && CollectionUtils.isNotEmpty(endSearchInfos)) {
            int order = 0;
            // 倒序循环
            for (int idx = beginSearchInfos.size() - 1; idx >= 0; idx--) {
                Map beginSearchInfo = beginSearchInfos.get(idx);//NOSONAR

                // 塞入logic字段，兼容显式设置paras.searchInfo.logic的情况
                if (StringUtils.isBlank(MapUtil.getStr(beginSearchInfo, Variables.SEARCH_INFO_LOGIC, StringUtils.EMPTY))) {
                    beginSearchInfo.put(Variables.SEARCH_INFO_LOGIC, Variables.SEARCH_INFO_LOGIC_AND);
                }
                // 塞入order字段，兼容显式设置paras.searchInfo.order的情况
                if (null == MapUtil.getInt(beginSearchInfo, Variables.SEARCH_INFO_ORDER)) {
                    beginSearchInfo.put(Variables.SEARCH_INFO_ORDER, order--);
                }
            }
            mergedResults.addAll(beginSearchInfos);
            mergedResults.addAll(endSearchInfos);
        } else if (CollectionUtils.isNotEmpty(beginSearchInfos)) {
            mergedResults.addAll(beginSearchInfos);
        } else if (CollectionUtils.isNotEmpty(endSearchInfos)) {
            mergedResults.addAll(endSearchInfos);
        }
        return mergedResults;
    }
}
