/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.domain;

import com.digiwin.athena.appcore.util.DataUtils;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.datasource.res.DesensitizationFieldsRes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.util.StringUtils;

public class QueryResult {
    private String dataSourceName;
    private List<String> dataKeys;
    private Integer totalResults;
    private boolean hasNext;
    private Integer pageSize = 50;
    private Integer pageNo = 1;
    private Integer pageCount;
    private boolean single;
    private Integer limit;
    private List<Map<String, Object>> data;
    private ApiMetadataCollection apiMetadataCollection;
    private List<ApiMetadataCollection> apiMetadataCollectionList;
    private Map<String, Integer> dataKeyIndex;
    private Integer abnormalDataKeyIndexSize;
    private Integer abnormalDataSize;
    private Collection<Map<String, Object>> returnPageInfo;
    private Map<String, Object> returnSummaryFields;
    private Map<String, Object> returnRequestData;
    public List<DesensitizationFieldsRes> desensitizationFields;

    public List<String> getDataKeys() {
        return this.dataKeys;
    }

    public void setDataKeys(List<String> dataKeys) {
        this.dataKeys = dataKeys;
    }

    public Integer getTotalResults() {
        return this.totalResults;
    }

    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
        if (totalResults == null) {
            this.hasNext = false;
            this.pageCount = 0;
        } else {
            this.pageCount = (totalResults + this.pageSize - 1) / this.pageSize;
        }
    }

    public boolean isHasNext() {
        return this.hasNext;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
        if (CollectionUtils.isNotEmpty(this.data) && this.data.size() > limit) {
            ArrayList<Map<String, Object>> newData = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < limit; ++i) {
                newData.add(this.data.get(i));
            }
            this.data = newData;
        }
    }

    public void removeTop(Integer size) {
        if (CollectionUtils.isNotEmpty(this.data) && this.data.size() > size) {
            for (int i = 0; i < size; ++i) {
                this.data.remove(0);
            }
            this.initializeDataKey();
        }
    }

    public static QueryResult empty() {
        QueryResult queryResult = new QueryResult();
        queryResult.setData(new ArrayList<Map<String, Object>>());
        queryResult.setDataKeyIndex(new HashMap<String, Integer>());
        return queryResult;
    }

    public static QueryResult empty(String dataSourceName) {
        QueryResult queryResult = new QueryResult();
        queryResult.setDataSourceName(dataSourceName);
        queryResult.setData(new ArrayList<Map<String, Object>>());
        queryResult.setDataKeyIndex(new HashMap<String, Integer>());
        return queryResult;
    }

    public static QueryResult withSingleData(String dataSourceName, Map<String, Object> data) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        if (MapUtils.isNotEmpty(data) && data.size() > 0) {
            dataList.add(data);
        }
        QueryResult queryResult = QueryResult.withData(dataSourceName, dataList);
        queryResult.setSingle(true);
        return queryResult;
    }

    public static QueryResult withData(String dataSourceName, Map<String, List<Object>> data) {
        List dataList = DataUtils.getMapFirstValueToList(data);
        if (StringUtils.isEmpty((Object)dataSourceName) && data.size() > 0) {
            dataSourceName = (String)data.keySet().toArray()[0];
        }
        QueryResult queryResult = QueryResult.withData(dataSourceName, dataList);
        return queryResult;
    }

    public static QueryResult withData(String dataSourceName, Map<String, Object> data, PageInfo pageInfo) {
        QueryResult queryResult = null;
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            Object val;
            String key = stringObjectEntry.getKey();
            if ("desensitizationFields".equals(key) || (val = stringObjectEntry.getValue()) == null) continue;
            if (StringUtils.isEmpty((Object)dataSourceName)) {
                dataSourceName = stringObjectEntry.getKey();
            }
            Object dataSourceVal = data.get(dataSourceName);
            if (data.size() > 1 && QueryResult.hasSourceVal(dataSourceVal)) {
                val = dataSourceVal;
            }
            if (val instanceof Collection) {
                List value = (List)val;
                queryResult = QueryResult.withData(dataSourceName, value);
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                break;
            }
            if (!(val instanceof Map)) continue;
            queryResult = QueryResult.withSingleData(dataSourceName, (Map)val);
            break;
        }
        if (queryResult == null) {
            queryResult = QueryResult.empty(dataSourceName);
        }
        if (pageInfo != null && pageInfo.getPageNo() != null && pageInfo.getPageSize() != null) {
            queryResult.setPageSize(pageInfo.getPageSize());
            queryResult.setPageNo(pageInfo.getPageNo());
        }
        return queryResult;
    }

    public static boolean hasSourceVal(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Collection) {
            List value = (List)val;
            if (CollectionUtils.isNotEmpty((Collection)value)) {
                return true;
            }
        } else if (val instanceof Map) {
            Map value = (Map)val;
            if (MapUtils.isNotEmpty((Map)value)) {
                return true;
            }
            return true;
        }
        return false;
    }

    public static QueryResult withData(String dataSourceName, List<Map<String, Object>> dataList) {
        QueryResult queryResult = new QueryResult();
        queryResult.setDataSourceName(dataSourceName);
        queryResult.setData(dataList);
        return queryResult;
    }

    public QueryResult withMetaData(ApiMetadataCollection apiMetadataCollection) {
        this.setApiMetadataCollection(apiMetadataCollection);
        return this;
    }

    public QueryResult withDataIndex(Map<String, Integer> dataKeyIndex) {
        this.setDataKeyIndex(dataKeyIndex);
        return this;
    }

    public QueryResult appendData(QueryResult queryResult) {
        int oldSize = this.data.size();
        this.getData().addAll(queryResult.getData());
        this.totalResults = this.calcResults(queryResult);
        Map<String, Integer> otherIndex = queryResult.getDataKeyIndex();
        otherIndex.forEach((key, integer) -> {
            if (!this.dataKeyIndex.containsKey(key)) {
                this.dataKeyIndex.put((String)key, integer + oldSize);
            }
        });
        return this;
    }

    private Integer calcResults(QueryResult queryResult) {
        BigDecimal thisValue = new BigDecimal(0);
        BigDecimal addValue = new BigDecimal(0);
        if (this.totalResults != null) {
            thisValue = new BigDecimal(this.totalResults);
        }
        if (queryResult.getTotalResults() != null) {
            addValue = new BigDecimal(queryResult.getTotalResults());
        }
        return Integer.valueOf(thisValue.add(addValue).toBigInteger().toString());
    }

    public QueryResult resetData(List<Map<String, Object>> dataList) {
        this.data.clear();
        if (this.dataKeyIndex != null) {
            this.dataKeyIndex.clear();
        }
        this.data = dataList;
        this.initializeDataKey();
        return this;
    }

    @JsonIgnore
    public int size() {
        if (CollectionUtils.isEmpty(this.getData())) {
            return 0;
        }
        return this.getData().size();
    }

    @JsonIgnore
    public int keySize() {
        if (MapUtils.isEmpty(this.getDataKeyIndex())) {
            return 0;
        }
        return this.getDataKeyIndex().size();
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
    }

    public ApiMetadataCollection getApiMetadataCollection() {
        return this.apiMetadataCollection;
    }

    private void setApiMetadataCollection(ApiMetadataCollection apiMetadataCollection) {
        this.apiMetadataCollection = apiMetadataCollection;
    }

    public List<ApiMetadataCollection> getApiMetadataCollectionList() {
        return this.apiMetadataCollectionList;
    }

    private void setApiMetadataCollectionList(List<ApiMetadataCollection> apiMetadataCollectionList) {
        this.apiMetadataCollectionList = apiMetadataCollectionList;
    }

    public String getDataSourceName() {
        if (this.dataSourceName == null) {
            this.dataSourceName = this.apiMetadataCollection != null && this.apiMetadataCollection.getMasterApiMetadata() != null && CollectionUtils.isNotEmpty(this.apiMetadataCollection.getMasterApiMetadata().getResponseFields()) ? this.apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getName() : "data";
        }
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public Map<String, Integer> getDataKeyIndex() {
        return this.dataKeyIndex;
    }

    private void setDataKeyIndex(Map<String, Integer> dataKeyIndex) {
        this.dataKeyIndex = dataKeyIndex;
    }

    @JsonIgnore
    public Map<String, Object> findByKey(String key) {
        if (this.dataKeyIndex == null) {
            return null;
        }
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        if (this.dataKeyIndex.containsKey(key)) {
            Integer index = this.dataKeyIndex.get(key);
            return this.data.get(index);
        }
        return null;
    }

    @JsonIgnore
    public Map<String, List<Map<String, Object>>> getPageData() {
        HashMap<String, List<Map<String, Object>>> pageData = new HashMap<String, List<Map<String, Object>>>();
        if (this.single && CollectionUtils.isNotEmpty(this.getData())) {
            pageData.put(this.getDataSourceName(), (List<Map<String, Object>>)((Object)this.getData().get(0)));
        } else {
            pageData.put(this.getDataSourceName(), this.getData());
        }
        return pageData;
    }

    public void initializeDataKey() {
        HashMap<String, Integer> dataKeyIndex = new HashMap<String, Integer>();
        if (CollectionUtils.isEmpty(this.getData()) || CollectionUtils.isEmpty(this.dataKeys)) {
            this.withDataIndex(dataKeyIndex);
            return;
        }
        int index = 0;
        for (Map<String, Object> datum : this.getData()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : this.dataKeys) {
                if (datum.containsKey(key)) {
                    stringBuilder.append(datum.get(key) == null ? "NAN" : datum.get(key).toString()).append(";");
                    continue;
                }
                stringBuilder.append("NAN;");
            }
            if (stringBuilder.length() > 0) {
                String key = stringBuilder.toString();
                datum.put("__DATA_KEY", key);
                dataKeyIndex.put(key, index);
            }
            ++index;
        }
        this.withDataIndex(dataKeyIndex);
    }

    public Integer getAbnormalDataKeyIndexSize() {
        if (null == this.abnormalDataKeyIndexSize) {
            return 0;
        }
        return this.abnormalDataKeyIndexSize;
    }

    public void setAbnormalDataKeyIndexSize(Integer abnormalDataKeyIndexSize) {
        this.abnormalDataKeyIndexSize = abnormalDataKeyIndexSize;
    }

    public Integer getAbnormalDataSize() {
        if (null == this.abnormalDataSize) {
            return 0;
        }
        return this.abnormalDataSize;
    }

    public void setAbnormalDataSize(Integer abnormalDataSize) {
        this.abnormalDataSize = abnormalDataSize;
    }

    public Collection<Map<String, Object>> getReturnPageInfo() {
        return this.returnPageInfo;
    }

    public void setReturnPageInfo(Collection<Map<String, Object>> returnPageInfo) {
        this.returnPageInfo = returnPageInfo;
    }

    public Map<String, Object> getReturnSummaryFields() {
        return this.returnSummaryFields;
    }

    public void setReturnSummaryFields(Map<String, Object> returnSummaryFields) {
        this.returnSummaryFields = returnSummaryFields;
    }

    public Map<String, Object> getReturnRequestData() {
        return this.returnRequestData;
    }

    public void setReturnRequestData(Map<String, Object> returnRequestData) {
        this.returnRequestData = returnRequestData;
    }

    public List<DesensitizationFieldsRes> getDesensitizationFields() {
        return this.desensitizationFields;
    }

    public void setDesensitizationFields(List<DesensitizationFieldsRes> desensitizationFields) {
        this.desensitizationFields = desensitizationFields;
    }
}

