/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.esp;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.domain.log.LogDataDto;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ChainInfoUtil;
import com.digiwin.athena.appcore.util.DataUtils;
import com.digiwin.athena.appcore.util.EspJacksonUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.digiwin.athena.atdm.audc.dto.TenantConfigDTO;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ActionServiceId;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.esp.dto.EspApiDTO;
import com.digiwin.athena.atdm.esp.dto.EspParam;
import com.digiwin.athena.atdm.esp.invoker.EspInvoker;
import com.digiwin.athena.atdm.util.SearchInfoUtil;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.CompressUtil;
import com.google.common.collect.Maps;
import io.seata.core.context.RootContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonESPServiceImpl
implements CommonESPService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonESPServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    RemoteProperties envProperties;
    @Autowired
    MessageUtils messageUtils;
    @Autowired
    private TokenVerifyService tokenVerifyService;
    @Resource
    private CommonAudcService audcService;
    public static final String TX_XID = "tx-xid";
    @Autowired
    private EspInvoker espInvoker;

    @Override
    public HashMap<String, Object> query(ExecuteContext executeContext, Action action, Map<String, Object> parameter) {
        if (parameter != null && action.getParas() == null && action.getActionParams() == null) {
            action.setParas(new HashMap<String, Object>());
            Map<String, Object> paras = action.getParas();
            for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                paras.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        ActionServiceId serviceId = this.getActionServiceId(executeContext.getTenantId(), executeContext.getPageCode(), executeContext.getPattern(), action, executeContext.getAuthoredUser());
        Map headers = this.createHeaders(serviceId, serviceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), action);
        if ("esp_doapi.input.invoice.query".equals(action.getActionId())) {
            headers.put("digi-appname", "bwcloudpi");
        }
        String body = EspJacksonUtil.toStringFromMapIgnoreKeys(action.initParas(action.getParas()));
        EspParam espParam = new EspParam();
        espParam.setBusinessUnit(action.getBusinessUnit());
        espParam.setActionExtendFields(action.getExtendedFields());
        espParam.setServiceId(serviceId);
        espParam.setHeaders(headers);
        espParam.setBody(body);
        espParam.setSync(true);
        espParam.setApplication(executeContext.getApplication());
        espParam.setTmActivityId(executeContext.getTmActivityId());
        espParam.setPattern(executeContext.getPattern());
        espParam.setPageCode(executeContext.getPageCode());
        return this.invokeEsp(espParam);
    }

    private ActionServiceId getActionServiceId(String tenantId, String pageCode, String pattern, Action action, AuthoredUser authoredUser) {
        ActionServiceId serviceId = action.getServiceId();
        if (serviceId == null) {
            serviceId = new ActionServiceId();
            serviceId.setTenant_id(tenantId);
            serviceId.setHostAcct("athena");
            serviceId.setName(action.getActionId().replace("esp_", ""));
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)serviceId.getName())) {
            serviceId.setName(action.getActionId().replace("esp_", ""));
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)serviceId.getTenant_id())) {
            serviceId.setTenant_id(tenantId);
        }
        if (StringUtils.isNotBlank((String)AppAuthContextHolder.getContext().getProxyToken())) {
            serviceId.setProxyToken(AppAuthContextHolder.getContext().getProxyToken());
        }
        String hostAcct = this.getHostAcct(pageCode, pattern, authoredUser);
        serviceId.setHostAcct(hostAcct);
        return serviceId;
    }

    @Override
    public HashMap<String, Object> queryByApiName(ExecuteContext executeContext, String apiName, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        Action tmAction = new Action();
        tmAction.setCategory("ESP");
        if (!apiName.startsWith("esp")) {
            tmAction.setActionId("esp_" + apiName);
        } else {
            tmAction.setActionId(apiName);
        }
        ActionServiceId actionServiceId = this.getActionServiceId(executeContext.getTenantId(), executeContext.getPageCode(), executeContext.getPattern(), tmAction, executeContext.getAuthoredUser());
        Map headers = this.createHeaders(actionServiceId, actionServiceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), null);
        HashMap bodyMap = new HashMap();
        HashMap<String, Map<String, Object>> std_data = new HashMap<String, Map<String, Object>>();
        if (parameter == null) {
            parameter = new HashMap<String, Object>();
        }
        if (pageInfo != null) {
            if (pageInfo.getPageSize() != null) {
                parameter.put("use_has_next", true);
                parameter.put("page_size", pageInfo.getPageSize());
            }
            if (pageInfo.getPageNo() != null) {
                parameter.put("page_no", pageInfo.getPageNo());
            }
        }
        if (CollectionUtils.isNotEmpty(sortInfo)) {
            parameter.put("sort_info", sortInfo);
        }
        if (CollectionUtils.isNotEmpty(searchInfo)) {
            parameter.put("search_value", "");
            parameter.put("search_info", SearchInfoUtil.mergeSearchInfo((List)parameter.get("search_info"), searchInfo));
        }
        bodyMap.put("std_data", std_data);
        std_data.put("parameter", parameter);
        if (!parameter.containsKey("enterprise_no") && executeContext.getBusinessUnit() != null) {
            if (executeContext.getBusinessUnit().containsKey("eoc_company_id")) {
                parameter.put("enterprise_no", executeContext.getBusinessUnit().get("eoc_company_id"));
            } else {
                parameter.put("enterprise_no", "enterprise_no");
            }
            if (executeContext.getBusinessUnit().containsKey("eoc_site_id")) {
                parameter.put("site_no", executeContext.getBusinessUnit().get("eoc_site_id"));
            } else {
                parameter.put("site_no", "site_no");
            }
        }
        String body = EspJacksonUtil.toStringFromMapIgnoreKeys(bodyMap);
        EspParam espParam = new EspParam();
        espParam.setBusinessUnit(executeContext.getBusinessUnit());
        espParam.setActionExtendFields(null);
        espParam.setServiceId(actionServiceId);
        espParam.setHeaders(headers);
        espParam.setBody(body);
        espParam.setSync(true);
        espParam.setApplication(executeContext.getApplication());
        espParam.setTmActivityId(executeContext.getTmActivityId());
        espParam.setPattern(executeContext.getPattern());
        espParam.setPageCode(executeContext.getPageCode());
        return this.invokeEsp(espParam);
    }

    public HashMap execute(SubmitExecuteContext executeContext, Action action) {
        HashMap resultMap = this.executeReturnAll(executeContext, action);
        if (MapUtils.isEmpty((Map)resultMap) || !resultMap.containsKey("data") || null == resultMap.get("data")) {
            return null;
        }
        return (HashMap)resultMap.get("data");
    }

    public HashMap executeReturnAll(SubmitExecuteContext executeContext, Action action) {
        ActionServiceId serviceId = this.getActionServiceId(executeContext.getTenantId(), executeContext.getPageCode(), executeContext.getPattern(), action, executeContext.getAuthoredUser());
        Map headers = this.createHeaders(serviceId, serviceId.getProxyToken(), executeContext.getAuthoredUser().getToken(), executeContext.getLocale(), action);
        String body = "";
        if (action.getParas() != null && action.getParas().size() > 0) {
            Optional optionalStringObjectMap = DataUtils.mergeMap((Map[])new Map[]{action.getParas()});
            body = EspJacksonUtil.toStringFromMapIgnoreKeys(action.initParas((Map)optionalStringObjectMap.get()));
        }
        if (Boolean.TRUE.equals(action.getNeedCompress())) {
            headers.put("digi-use-compressed", "true");
            body = CompressUtil.compressBody((String)body);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)action.getInvokeType())) {
            action.setInvokeType(this.getApiMetadataInvokeType(serviceId.getName()));
        }
        boolean sync = org.springframework.util.StringUtils.isEmpty((Object)action.getInvokeType()) || "sync".equals(action.getInvokeType());
        EspParam espParam = new EspParam();
        espParam.setBusinessUnit(action.getBusinessUnit());
        espParam.setActionExtendFields(action.getExtendedFields());
        espParam.setServiceId(serviceId);
        espParam.setHeaders(headers);
        espParam.setBody(body);
        espParam.setSync(sync);
        espParam.setApplication(executeContext.getApplication());
        espParam.setTmActivityId(executeContext.getTmActivityId());
        espParam.setPattern(executeContext.getPattern());
        espParam.setPageCode(executeContext.getPageCode());
        return this.invokeEspReturnAll(espParam);
    }

    @Override
    public String getApiMetadataInvokeType(String apiName) {
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.add("Content-Type", "application/json;charset=UTF-8");
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("api_name", apiName);
        String uri = this.envProperties.getMdcLbUri() + "/restful/standard/mdc/ApiMetadata/Get";
        HttpEntity httpEntity = new HttpEntity(paraMap, (MultiValueMap)headerMap);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(uri, (Object)httpEntity, EspApiDTO.class, new Object[0]);
        if (((EspApiDTO)responseEntity.getBody()).getExecution() != null && !"000".equals(((EspApiDTO)responseEntity.getBody()).getExecution().getCode())) {
            return "sync";
        }
        EspApiDTO resultDTO = (EspApiDTO)responseEntity.getBody();
        return resultDTO.getData().getType();
    }

    private HashMap invokeEsp(EspParam espParam) {
        HashMap resultMap = this.invokeEspReturnAll(espParam);
        if (MapUtils.isEmpty((Map)resultMap) || !resultMap.containsKey("data") || null == resultMap.get("data")) {
            return null;
        }
        return (HashMap)resultMap.get("data");
    }

    private HashMap invokeEspReturnAll(EspParam espParam) {
        ResponseModel responseModel;
        ActionServiceId serviceId = espParam.getServiceId();
        serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;
        String tenantId = serviceId.getTenant_id();
        String serviceName = serviceId.getName();
        RequestModel requestModel = this.createEspRequestModel(espParam);
        try {
            responseModel = this.espInvoker.invokeRest(espParam.isSync(), requestModel);
        }
        catch (Exception e) {
            if (e instanceof InvocationException) {
                InvocationException invocationException = (InvocationException)e;
                BusinessException businessException = BusinessException.create((String)invocationException.getErrorCode(), (String)invocationException.getErrorMessage(), (Throwable)e);
                businessException.setErrorInstructors((Map)Maps.newHashMap());
                businessException.getErrorInstructors().put("chainInfo", invocationException.getChainInfo());
                throw businessException;
            }
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail"), serviceId.getName(), e.getMessage());
            throw BusinessException.create((String)ErrorCodeEnum.ESP_EXECUTE_ERROR.getErrCode(), (String)error, (Throwable)e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap responseMap = this.throwEspError(serviceId.getName(), responseModel, requestModel);
        HashMap stdDataMap = responseMap.getOrDefault("std_data", null);
        if (stdDataMap != null) {
            resultMap.put("data", stdDataMap.getOrDefault("parameter", null));
        }
        resultMap.put("sync", espParam.isSync());
        resultMap.put("reqId", responseModel.getReqid());
        LogDto logDtoEnd = new LogDto("\u6267\u884cesp\u7ed3\u675f\uff0cservice name\uff1a" + serviceName, tenantId + ";" + serviceName);
        LogDataDto logDataDtoEnd = new LogDataDto(responseModel.getReqid(), "esp\u8bf7\u6c42id", "link", "esp");
        logDtoEnd.setData(Arrays.asList(logDataDtoEnd));
        log.info(logDtoEnd.toString());
        return resultMap;
    }

    private HashMap throwEspError(String serviceId, ResponseModel responseModel, RequestModel requestModel) {
        String serviceProd = requestModel.getServiceProd();
        String errorCode = ErrorCodeEnum.ESP_EXECUTE_RETURN_ERROR.getErrCode();
        if (!org.springframework.util.StringUtils.isEmpty((Object)serviceProd)) {
            errorCode = "P." + serviceProd + ".500.599";
        }
        if (!responseModel.getEspCode().startsWith("0")) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail"), serviceId, responseModel.getEspMessage());
            throw BusinessException.create((Integer)599, (String)errorCode, (String)error);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)responseModel.getBodyJsonString())) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail2"), serviceId);
            throw BusinessException.create((Integer)599, (String)errorCode, (String)error);
        }
        HashMap espResponse = (HashMap)JsonUtils.jsonToObject((String)responseModel.getBodyJsonString(), HashMap.class);
        if (espResponse.containsKey("error")) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail"), serviceId, espResponse.get("error"));
            throw BusinessException.create((Integer)599, (String)errorCode, (String)error);
        }
        HashMap stdDataMap = espResponse.getOrDefault("std_data", null);
        if (stdDataMap == null) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail3"), serviceId, responseModel.getBodyJsonString());
            throw BusinessException.create((Integer)599, (String)errorCode, (String)error);
        }
        HashMap execution = stdDataMap.getOrDefault("execution", null);
        if (execution == null) {
            String error = String.format(this.messageUtils.getMessage("exception.execution.api.fail4"), serviceId, responseModel.getBodyJsonString());
            throw BusinessException.create((Integer)599, (String)errorCode, (String)error);
        }
        if (!"000".equals(responseModel.getSrvCode())) {
            String description = execution.getOrDefault("description", "");
            String code = execution.getOrDefault("code", "");
            String string = errorCode = org.springframework.util.StringUtils.isEmpty((Object)code) ? errorCode : code;
            if ("-1".equals(code)) {
                errorCode = "P." + serviceProd + ".9999.9999";
            }
            String displayDescription = String.format(this.messageUtils.getMessage("exception.execution.api.fail5"), serviceId, responseModel.getBodyJsonString());
            BusinessException businessException = BusinessException.create((Integer)500, (String)errorCode, (Object)description, (String)displayDescription, (String)"", (String)ErrorTypeEnum.BUSINESS.getValue(), null);
            businessException.setErrorInstructors((Map)Maps.newHashMap());
            businessException.getErrorInstructors().put("source", "application");
            businessException.setEspError((Map)execution);
            throw businessException;
        }
        return espResponse;
    }

    private RequestModel createEspRequestModel(EspParam espParam) {
        String taskType;
        Map businessUnit = espParam.getBusinessUnit();
        Map<String, Object> actionExtendFields = espParam.getActionExtendFields();
        ActionServiceId serviceId = espParam.getServiceId();
        Map<String, String> headers = espParam.getHeaders();
        String body = espParam.getBody();
        String application = espParam.getApplication();
        log.error("serviceId: {}", (Object)JsonUtils.objectToString((Object)serviceId));
        serviceId = serviceId == null ? ActionServiceId.empty() : serviceId;
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("Athena");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("AgileInteraction");
        requestModel.setHostAcct(serviceId.getHostAcct());
        requestModel.setTenantId(serviceId.getTenant_id());
        requestModel.setServiceProd(serviceId.getProd());
        requestModel.setServiceProdUid(serviceId.getUid());
        requestModel.setServiceName(serviceId.getName());
        requestModel.setDatakeyMap(null);
        requestModel.setHeaderMap(headers);
        requestModel.setBodyJsonString(body);
        requestModel.setEocMap(businessUnit);
        if (headers.containsKey("locale")) {
            requestModel.setLanguage(headers.get("locale"));
        } else {
            requestModel.setLanguage(LocaleContextHolder.getLocale().toString());
        }
        HashMap dataKeyMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(actionExtendFields)) {
            actionExtendFields.forEach((key, value) -> dataKeyMap.put(key, String.valueOf(value)));
        }
        dataKeyMap.put("__PtxId", MDC.get((String)"PtxId"));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)application)) {
            dataKeyMap.put("appCode", application);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(taskType = (String)Optional.ofNullable(espParam.getPageCode()).map(pageCode -> {
            switch (pageCode) {
                case "task-card": 
                case "task-detail": 
                case "project-card": 
                case "project-detail": {
                    return "TASK";
                }
                case "basic-data": 
                case "browse-page": 
                case "edit-page": {
                    return "DATA_ENTRY";
                }
            }
            return null;
        }).orElse(null))) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)espParam.getTmActivityId())) {
            dataKeyMap.put("taskType", taskType);
            dataKeyMap.put("taskCode", espParam.getTmActivityId());
        }
        requestModel.setDatakeyMap((Map)dataKeyMap);
        return requestModel;
    }

    private Map createHeaders(ActionServiceId serviceId, String proxyToken, String token, String local, Action action) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (proxyToken != null) {
            headers.put("token", proxyToken);
        } else if (AppAuthContextHolder.getContext().getProxyToken() != null) {
            AuthoredUser proxyAuthoredUser = this.tokenVerifyService.getUserInfo(AppAuthContextHolder.getContext().getProxyToken());
            serviceId.setTenant_id(proxyAuthoredUser.getTenantId());
            headers.put("token", AppAuthContextHolder.getContext().getProxyToken());
        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headers.put("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        } else if (token != null) {
            headers.put("token", token);
        }
        if (AppAuthContextHolder.getContext().getSecurityToken() != null) {
            headers.put("security-token", AppAuthContextHolder.getContext().getSecurityToken());
        }
        if (!headers.containsKey("routerKey")) {
            String routerKey = MDC.get((String)"routerKey");
            if (org.springframework.util.StringUtils.hasText((String)routerKey)) {
                headers.put("routerKey", routerKey);
            } else if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
                headers.put("routerKey", AppAuthContextHolder.getContext().getProxyAuthoredUser().getTenantId());
            } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
                headers.put("routerKey", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            }
        }
        headers.put("locale", local);
        headers.put("digi-dap-service-chain-info", ChainInfoUtil.genInvokeChainInfo((String)MDC.get((String)"digi-dap-service-chain-info")));
        if (RootContext.getXID() != null) {
            headers.put(TX_XID, RootContext.getXID());
        }
        return headers;
    }

    private String getHostAcct(String pageCode, String pattern, AuthoredUser executeContextUser) {
        if ("basic-data".equals(pageCode) || "DIALOG".equals(pattern)) {
            AuthoredUser authoredUser = null;
            if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
                authoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
            } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
                authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            } else if (null != executeContextUser) {
                authoredUser = executeContextUser;
            }
            if (this.enableTenantDataManage(authoredUser)) {
                return authoredUser.getUserId();
            }
        }
        return "athena";
    }

    private boolean enableTenantDataManage(AuthoredUser authoredUser) {
        if (null == authoredUser || !org.springframework.util.StringUtils.hasText((String)authoredUser.getTenantId())) {
            return false;
        }
        String tenantId = authoredUser.getTenantId();
        String category = "enableDataManage";
        try {
            TenantConfigDTO tenantConfig = this.audcService.getTenantConfig(tenantId, category);
            return null != tenantConfig && "TRUE".equalsIgnoreCase(tenantConfig.getConfigValue());
        }
        catch (Exception ex) {
            log.error("[EspServiceImpl] query enableTenantDataManage for tenantId: {}, category: {} failed: {} ", new Object[]{tenantId, category, ex});
            return false;
        }
    }
}

